/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.testdata.domain.shadow.extended;

import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListenerAdapter;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.shadow.extended.TestdataExtendedShadowedParentEntity;
import org.optaplanner.core.impl.testdata.domain.shadow.extended.TestdataExtendedShadowedSolution;

@PlanningEntity
public class TestdataExtendedShadowedChildEntity
extends TestdataExtendedShadowedParentEntity {
    private String secondShadow;

    public static EntityDescriptor buildEntityDescriptor() {
        SolutionDescriptor solutionDescriptor = TestdataExtendedShadowedSolution.buildSolutionDescriptor();
        return solutionDescriptor.findEntityDescriptorOrFail(TestdataExtendedShadowedChildEntity.class);
    }

    public TestdataExtendedShadowedChildEntity() {
    }

    public TestdataExtendedShadowedChildEntity(String code) {
        super(code);
    }

    public TestdataExtendedShadowedChildEntity(String code, TestdataValue value) {
        super(code, value);
    }

    @CustomShadowVariable(variableListenerClass=SecondShadowUpdatingVariableListener.class, sources={@CustomShadowVariable.Source(variableName="firstShadow")})
    public String getSecondShadow() {
        return this.secondShadow;
    }

    public void setSecondShadow(String secondShadow) {
        this.secondShadow = secondShadow;
    }

    public static class SecondShadowUpdatingVariableListener
    extends VariableListenerAdapter<TestdataExtendedShadowedParentEntity> {
        public void afterEntityAdded(ScoreDirector scoreDirector, TestdataExtendedShadowedParentEntity entity) {
            this.updateShadow(scoreDirector, entity);
        }

        public void afterVariableChanged(ScoreDirector scoreDirector, TestdataExtendedShadowedParentEntity entity) {
            this.updateShadow(scoreDirector, entity);
        }

        private void updateShadow(ScoreDirector scoreDirector, TestdataExtendedShadowedParentEntity entity) {
            String firstShadow = entity.getFirstShadow();
            if (entity instanceof TestdataExtendedShadowedChildEntity) {
                TestdataExtendedShadowedChildEntity childEntity = (TestdataExtendedShadowedChildEntity)entity;
                scoreDirector.beforeVariableChanged((Object)childEntity, "secondShadow");
                childEntity.setSecondShadow(firstShadow == null ? null : firstShadow + "/secondShadow");
                scoreDirector.afterVariableChanged((Object)childEntity, "secondShadow");
            }
        }
    }
}

