/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.testdata.util;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.core.impl.score.director.easy.EasyScoreDirectorFactory;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class PlannerTestUtils {
    public static InnerScoreDirector mockScoreDirector(SolutionDescriptor solutionDescriptor) {
        EasyScoreDirectorFactory scoreDirectorFactory = new EasyScoreDirectorFactory(new EasyScoreCalculator(){

            public Score calculateScore(Solution solution) {
                return SimpleScore.valueOf((int)0);
            }
        });
        scoreDirectorFactory.setSolutionDescriptor(solutionDescriptor);
        scoreDirectorFactory.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        scoreDirectorFactory.setInitializingScoreTrend(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)1));
        return (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class, (Answer)AdditionalAnswers.delegatesTo((Object)scoreDirectorFactory.buildScoreDirector(false)));
    }

    public static <T> void serializeAndDeserializeWithAll(T input, OutputAsserter<T> outputAsserter) {
        outputAsserter.assertOutput(PlannerTestUtils.serializeAndDeserializeWithJavaSerialization(input));
        outputAsserter.assertOutput(PlannerTestUtils.serializeAndDeserializeWithXStream(input));
    }

    public static <T> T serializeAndDeserializeWithJavaSerialization(T input) {
        byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)input));
        return (T)SerializationUtils.deserialize((byte[])bytes);
    }

    public static <T> T serializeAndDeserializeWithXStream(T input) {
        XStream xStream = new XStream();
        xStream.setMode(1002);
        if (input != null) {
            xStream.processAnnotations(input.getClass());
        }
        String xmlString = xStream.toXML(input);
        return (T)xStream.fromXML(xmlString);
    }

    private PlannerTestUtils() {
    }

    public static interface OutputAsserter<T> {
        public void assertOutput(T var1);
    }
}

