/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplebigdecimal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.optaplanner.core.api.score.AbstractScore;

public final class SimpleBigDecimalScore
extends AbstractScore<SimpleBigDecimalScore> {
    private final BigDecimal score;

    public static SimpleBigDecimalScore parseScore(String scoreString) {
        return SimpleBigDecimalScore.valueOf(SimpleBigDecimalScore.parseLevelAsBigDecimal(SimpleBigDecimalScore.class, scoreString, scoreString));
    }

    public static SimpleBigDecimalScore valueOf(BigDecimal score) {
        return new SimpleBigDecimalScore(score);
    }

    private SimpleBigDecimalScore(BigDecimal score) {
        this.score = score;
    }

    public BigDecimal getScore() {
        return this.score;
    }

    @Override
    public SimpleBigDecimalScore add(SimpleBigDecimalScore augment) {
        return new SimpleBigDecimalScore(this.score.add(augment.getScore()));
    }

    @Override
    public SimpleBigDecimalScore subtract(SimpleBigDecimalScore subtrahend) {
        return new SimpleBigDecimalScore(this.score.subtract(subtrahend.getScore()));
    }

    @Override
    public SimpleBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return new SimpleBigDecimalScore(this.score.multiply(multiplicandBigDecimal).setScale(this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return new SimpleBigDecimalScore(this.score.divide(divisorBigDecimal, this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return new SimpleBigDecimalScore(this.score.pow(exponentBigDecimal.intValue()).setScale(this.score.scale()));
    }

    @Override
    public SimpleBigDecimalScore negate() {
        return new SimpleBigDecimalScore(this.score.negate());
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleBigDecimalScore) {
            SimpleBigDecimalScore other = (SimpleBigDecimalScore)o;
            return this.score.equals(other.getScore());
        }
        return false;
    }

    public int hashCode() {
        return 629 + this.score.hashCode();
    }

    @Override
    public int compareTo(SimpleBigDecimalScore other) {
        if (this.score.compareTo(other.getScore()) < 0) {
            return -1;
        }
        if (this.score.compareTo(other.getScore()) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.score.toString();
    }
}

