/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.AbstractSolverFactory;

public class XStreamXmlSolverFactory<Solution_ extends Solution>
extends AbstractSolverFactory<Solution_> {
    protected XStream xStream = XStreamXmlSolverFactory.buildXStream();

    public static XStream buildXStream() {
        XStream xStream = new XStream();
        xStream.setMode(1002);
        xStream.aliasSystemAttribute("xStreamId", "id");
        xStream.aliasSystemAttribute("xStreamRef", "reference");
        xStream.processAnnotations(SolverConfig.class);
        return xStream;
    }

    public XStreamXmlSolverFactory() {
        this(new SolverConfigContext());
    }

    public XStreamXmlSolverFactory(SolverConfigContext solverConfigContext) {
        super(solverConfigContext);
        if (solverConfigContext.getClassLoader() != null) {
            this.xStream.setClassLoader(solverConfigContext.getClassLoader());
        }
    }

    public void addXStreamAnnotations(Class ... xStreamAnnotations) {
        this.xStream.processAnnotations(xStreamAnnotations);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public XStreamXmlSolverFactory<Solution_> configure(String solverConfigResource) {
        ClassLoader actualClassLoader = this.solverConfigContext.determineActualClassLoader();
        InputStream in = actualClassLoader.getResourceAsStream(solverConfigResource);
        if (in == null) {
            String errorMessage = "The solverConfigResource (" + solverConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
            if (solverConfigResource.startsWith("/")) {
                errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A solverConfigResource now adheres to ClassLoader.getResource(String). Remove the leading slash from the solverConfigResource if you're upgrading from 6.0.";
            }
            throw new IllegalArgumentException(errorMessage);
        }
        try {
            return this.configure(in);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Unmarshalling of solverConfigResource (" + solverConfigResource + ") fails.", e);
        }
    }

    public XStreamXmlSolverFactory<Solution_> configure(File solverConfigFile) {
        try {
            return this.configure(new FileInputStream(solverConfigFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The solverConfigFile (" + solverConfigFile + ") was not found.", e);
        }
    }

    public XStreamXmlSolverFactory<Solution_> configure(InputStream in) {
        XStreamXmlSolverFactory<Solution_> xStreamXmlSolverFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            xStreamXmlSolverFactory = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xStreamXmlSolverFactory;
    }

    public XStreamXmlSolverFactory<Solution_> configure(Reader reader) {
        this.solverConfig = (SolverConfig)this.xStream.fromXML(reader);
        return this;
    }
}

