/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainChangeMove
extends AbstractMove {
    private final SubChain subChain;
    private final GenuineVariableDescriptor variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    private final Object toPlanningValue;

    public SubChainChangeMove(SubChain subChain, GenuineVariableDescriptor variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, Object toPlanningValue) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.toPlanningValue = toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        if (this.subChain.getEntityList().contains(this.toPlanningValue)) {
            return false;
        }
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return !ObjectUtils.equals((Object)oldFirstValue, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return new SubChainChangeMove(this.subChain, this.variableDescriptor, this.inverseVariableSupply, oldFirstValue);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        Object newTrailingEntity;
        Object firstEntity = this.subChain.getFirstEntity();
        Object lastEntity = this.subChain.getLastEntity();
        Object oldFirstValue = this.variableDescriptor.getValue(firstEntity);
        Object oldTrailingLastEntity = this.inverseVariableSupply.getInverseSingleton(lastEntity);
        Object object = newTrailingEntity = this.toPlanningValue == null ? null : this.inverseVariableSupply.getInverseSingleton(this.toPlanningValue);
        if (oldTrailingLastEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, oldTrailingLastEntity, oldFirstValue);
        }
        scoreDirector.changeVariableFacade(this.variableDescriptor, firstEntity, this.toPlanningValue);
        if (newTrailingEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, newTrailingEntity, lastEntity);
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.subChain.getEntityList();
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainChangeMove) {
            SubChainChangeMove other = (SubChainChangeMove)o;
            return new EqualsBuilder().append((Object)this.subChain, (Object)other.subChain).append((Object)this.variableDescriptor, (Object)other.variableDescriptor).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.subChain).append((Object)this.variableDescriptor).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return this.subChain.toDottedString() + " {" + oldFirstValue + " -> " + this.toPlanningValue + "}";
    }
}

