/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;

public final class HardSoftBigDecimalScore
extends AbstractScore<HardSoftBigDecimalScore>
implements FeasibilityScore<HardSoftBigDecimalScore> {
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final BigDecimal hardScore;
    private final BigDecimal softScore;

    public static HardSoftBigDecimalScore parseScore(String scoreString) {
        String[] levelStrings = HardSoftBigDecimalScore.parseLevelStrings(HardSoftBigDecimalScore.class, scoreString, HARD_LABEL, SOFT_LABEL);
        BigDecimal hardScore = HardSoftBigDecimalScore.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, levelStrings[0]);
        BigDecimal softScore = HardSoftBigDecimalScore.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, levelStrings[1]);
        return HardSoftBigDecimalScore.valueOf(hardScore, softScore);
    }

    public static HardSoftBigDecimalScore valueOf(BigDecimal hardScore, BigDecimal softScore) {
        return new HardSoftBigDecimalScore(hardScore, softScore);
    }

    private HardSoftBigDecimalScore() {
        this.hardScore = null;
        this.softScore = null;
    }

    private HardSoftBigDecimalScore(BigDecimal hardScore, BigDecimal softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.getHardScore().compareTo(BigDecimal.ZERO) >= 0;
    }

    @Override
    public HardSoftBigDecimalScore add(HardSoftBigDecimalScore augment) {
        return new HardSoftBigDecimalScore(this.hardScore.add(augment.getHardScore()), this.softScore.add(augment.getSoftScore()));
    }

    @Override
    public HardSoftBigDecimalScore subtract(HardSoftBigDecimalScore subtrahend) {
        return new HardSoftBigDecimalScore(this.hardScore.subtract(subtrahend.getHardScore()), this.softScore.subtract(subtrahend.getSoftScore()));
    }

    @Override
    public HardSoftBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return new HardSoftBigDecimalScore(this.hardScore.multiply(multiplicandBigDecimal).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.multiply(multiplicandBigDecimal).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return new HardSoftBigDecimalScore(this.hardScore.divide(divisorBigDecimal, this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.divide(divisorBigDecimal, this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return new HardSoftBigDecimalScore(this.hardScore.pow(exponentBigDecimal.intValue()).setScale(this.hardScore.scale()), this.softScore.pow(exponentBigDecimal.intValue()).setScale(this.softScore.scale()));
    }

    @Override
    public HardSoftBigDecimalScore negate() {
        return new HardSoftBigDecimalScore(this.hardScore.negate(), this.softScore.negate());
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftBigDecimalScore) {
            HardSoftBigDecimalScore other = (HardSoftBigDecimalScore)o;
            return this.hardScore.equals(other.getHardScore()) && this.softScore.equals(other.getSoftScore());
        }
        return false;
    }

    public int hashCode() {
        return (629 + this.hardScore.hashCode()) * 37 + this.softScore.hashCode();
    }

    @Override
    public int compareTo(HardSoftBigDecimalScore other) {
        if (this.hardScore.compareTo(other.getHardScore()) != 0) {
            if (this.hardScore.compareTo(other.getHardScore()) < 0) {
                return -1;
            }
            return 1;
        }
        if (this.softScore.compareTo(other.getSoftScore()) < 0) {
            return -1;
        }
        if (this.softScore.compareTo(other.getSoftScore()) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

