/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.domain.ScanAnnotatedClassesConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.random.RandomType;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.random.DefaultRandomFactory;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="solver")
public class SolverConfig
extends AbstractConfig<SolverConfig> {
    protected static final long DEFAULT_RANDOM_SEED = 0L;
    protected EnvironmentMode environmentMode = null;
    protected Boolean daemon = null;
    protected RandomType randomType = null;
    protected Long randomSeed = null;
    protected Class<? extends RandomFactory> randomFactoryClass = null;
    @XStreamAlias(value="scanAnnotatedClasses")
    protected ScanAnnotatedClassesConfig scanAnnotatedClassesConfig = null;
    protected Class<? extends Solution> solutionClass = null;
    @XStreamImplicit(itemFieldName="entityClass")
    protected List<Class<?>> entityClassList = null;
    @XStreamAlias(value="scoreDirectorFactory")
    protected ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = null;
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig;
    @XStreamImplicit
    protected List<PhaseConfig> phaseConfigList = null;

    public SolverConfig() {
    }

    public SolverConfig(SolverConfig inheritedConfig) {
        this.inherit(inheritedConfig);
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Boolean getDaemon() {
        return this.daemon;
    }

    public void setDaemon(Boolean daemon) {
        this.daemon = daemon;
    }

    public RandomType getRandomType() {
        return this.randomType;
    }

    public void setRandomType(RandomType randomType) {
        this.randomType = randomType;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Class<? extends RandomFactory> getRandomFactoryClass() {
        return this.randomFactoryClass;
    }

    public void setRandomFactoryClass(Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
    }

    public ScanAnnotatedClassesConfig getScanAnnotatedClassesConfig() {
        return this.scanAnnotatedClassesConfig;
    }

    public void setScanAnnotatedClassesConfig(ScanAnnotatedClassesConfig scanAnnotatedClassesConfig) {
        this.scanAnnotatedClassesConfig = scanAnnotatedClassesConfig;
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public void setSolutionClass(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
    }

    public List<Class<?>> getEntityClassList() {
        return this.entityClassList;
    }

    public void setEntityClassList(List<Class<?>> entityClassList) {
        this.entityClassList = entityClassList;
    }

    public ScoreDirectorFactoryConfig getScoreDirectorFactoryConfig() {
        return this.scoreDirectorFactoryConfig;
    }

    public void setScoreDirectorFactoryConfig(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
    }

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public List<PhaseConfig> getPhaseConfigList() {
        return this.phaseConfigList;
    }

    public void setPhaseConfigList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    public EnvironmentMode determineEnvironmentMode() {
        return (EnvironmentMode)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.environmentMode), (Object)((Object)EnvironmentMode.REPRODUCIBLE)));
    }

    public void offerRandomSeedFromSubSingleIndex(long subSingleIndex) {
        if ((this.environmentMode == null || this.environmentMode.isReproducible()) && this.randomFactoryClass == null && this.randomSeed == null) {
            this.randomSeed = subSingleIndex;
        }
    }

    @Deprecated
    public <Solution_ extends Solution> Solver<Solution_> buildSolver() {
        return this.buildSolver(new SolverConfigContext());
    }

    @Deprecated
    public <Solution_ extends Solution> Solver<Solution_> buildSolver(ClassLoader classLoader) {
        SolverConfigContext configContext = new SolverConfigContext();
        configContext.setClassLoader(classLoader);
        return this.buildSolver(configContext);
    }

    public <Solution_ extends Solution> Solver<Solution_> buildSolver(SolverConfigContext configContext) {
        configContext.validate();
        DefaultSolver solver = new DefaultSolver();
        EnvironmentMode environmentMode_ = this.determineEnvironmentMode();
        solver.setEnvironmentMode(environmentMode_);
        boolean daemon_ = (Boolean)ObjectUtils.defaultIfNull((Object)this.daemon, (Object)false);
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination(daemon_);
        solver.setBasicPlumbingTermination(basicPlumbingTermination);
        solver.setRandomFactory(this.buildRandomFactory(environmentMode_));
        SolutionDescriptor solutionDescriptor = this.buildSolutionDescriptor(configContext);
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig_ = this.scoreDirectorFactoryConfig == null ? new ScoreDirectorFactoryConfig() : this.scoreDirectorFactoryConfig;
        InnerScoreDirectorFactory scoreDirectorFactory = scoreDirectorFactoryConfig_.buildScoreDirectorFactory(configContext, environmentMode_, solutionDescriptor);
        solver.setConstraintMatchEnabledPreference(environmentMode_.isAsserted());
        solver.setScoreDirectorFactory(scoreDirectorFactory);
        HeuristicConfigPolicy configPolicy = new HeuristicConfigPolicy(environmentMode_, scoreDirectorFactory);
        TerminationConfig terminationConfig_ = this.terminationConfig == null ? new TerminationConfig() : this.terminationConfig;
        Termination termination = terminationConfig_.buildTermination(configPolicy, basicPlumbingTermination);
        solver.setTermination(termination);
        BestSolutionRecaller bestSolutionRecaller = this.buildBestSolutionRecaller(environmentMode_);
        solver.setBestSolutionRecaller(bestSolutionRecaller);
        solver.setPhaseList(this.buildPhaseList(configPolicy, bestSolutionRecaller, termination));
        return solver;
    }

    protected RandomFactory buildRandomFactory(EnvironmentMode environmentMode_) {
        RandomFactory randomFactory;
        if (this.randomFactoryClass != null) {
            if (this.randomType != null || this.randomSeed != null) {
                throw new IllegalArgumentException("The solverConfig with randomFactoryClass (" + this.randomFactoryClass + ") has a non-null randomType (" + (Object)((Object)this.randomType) + ") or a non-null randomSeed (" + this.randomSeed + ").");
            }
            randomFactory = ConfigUtils.newInstance(this, "randomFactoryClass", this.randomFactoryClass);
        } else {
            RandomType randomType_ = (RandomType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.randomType), (Object)((Object)RandomType.JDK)));
            Long randomSeed_ = this.randomSeed;
            if (this.randomSeed == null && environmentMode_ != EnvironmentMode.PRODUCTION) {
                randomSeed_ = 0L;
            }
            randomFactory = new DefaultRandomFactory(randomType_, randomSeed_);
        }
        return randomFactory;
    }

    protected SolutionDescriptor buildSolutionDescriptor(SolverConfigContext configContext) {
        if (this.scanAnnotatedClassesConfig != null) {
            if (this.solutionClass != null || this.entityClassList != null) {
                throw new IllegalArgumentException("The solver configuration with scanAnnotatedClasses (" + this.scanAnnotatedClassesConfig + ") cannot also have a solutionClass (" + this.solutionClass + ") or an entityClass (" + this.entityClassList + ").\n  Please decide between automatic scanning or manual referencing.");
            }
            return this.scanAnnotatedClassesConfig.buildSolutionDescriptor(configContext);
        }
        if (this.solutionClass == null) {
            throw new IllegalArgumentException("The solver configuration must have a solutionClass (" + this.solutionClass + "), if it has no scanAnnotatedClasses (" + this.scanAnnotatedClassesConfig + ").");
        }
        if (ConfigUtils.isEmptyCollection(this.entityClassList)) {
            throw new IllegalArgumentException("The solver configuration must have at least 1 entityClass (" + this.entityClassList + "), if it has no scanAnnotatedClasses (" + this.scanAnnotatedClassesConfig + ").");
        }
        return SolutionDescriptor.buildSolutionDescriptor(this.solutionClass, this.entityClassList);
    }

    protected BestSolutionRecaller buildBestSolutionRecaller(EnvironmentMode environmentMode) {
        BestSolutionRecaller bestSolutionRecaller = new BestSolutionRecaller();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            bestSolutionRecaller.setAssertInitialScoreFromScratch(true);
            bestSolutionRecaller.setAssertShadowVariablesAreNotStale(true);
            bestSolutionRecaller.setAssertBestScoreIsUnmodified(true);
        }
        return bestSolutionRecaller;
    }

    protected List<Phase> buildPhaseList(HeuristicConfigPolicy configPolicy, BestSolutionRecaller bestSolutionRecaller, Termination termination) {
        List<PhaseConfig> phaseConfigList_ = this.phaseConfigList;
        if (ConfigUtils.isEmptyCollection(phaseConfigList_)) {
            phaseConfigList_ = new ArrayList<PhaseConfig>(2);
            phaseConfigList_.add(new ConstructionHeuristicPhaseConfig());
            phaseConfigList_.add(new LocalSearchPhaseConfig());
        }
        ArrayList<Phase> phaseList = new ArrayList<Phase>(phaseConfigList_.size());
        int phaseIndex = 0;
        for (PhaseConfig phaseConfig : phaseConfigList_) {
            Phase phase = phaseConfig.buildPhase(phaseIndex, configPolicy, bestSolutionRecaller, termination);
            phaseList.add(phase);
            ++phaseIndex;
        }
        return phaseList;
    }

    @Override
    public void inherit(SolverConfig inheritedConfig) {
        this.environmentMode = ConfigUtils.inheritOverwritableProperty(this.environmentMode, inheritedConfig.getEnvironmentMode());
        this.daemon = ConfigUtils.inheritOverwritableProperty(this.daemon, inheritedConfig.getDaemon());
        this.randomType = ConfigUtils.inheritOverwritableProperty(this.randomType, inheritedConfig.getRandomType());
        this.randomSeed = ConfigUtils.inheritOverwritableProperty(this.randomSeed, inheritedConfig.getRandomSeed());
        this.randomFactoryClass = ConfigUtils.inheritOverwritableProperty(this.randomFactoryClass, inheritedConfig.getRandomFactoryClass());
        this.scanAnnotatedClassesConfig = ConfigUtils.inheritConfig(this.scanAnnotatedClassesConfig, inheritedConfig.getScanAnnotatedClassesConfig());
        this.solutionClass = ConfigUtils.inheritOverwritableProperty(this.solutionClass, inheritedConfig.getSolutionClass());
        this.entityClassList = ConfigUtils.inheritMergeableListProperty(this.entityClassList, inheritedConfig.getEntityClassList());
        this.scoreDirectorFactoryConfig = ConfigUtils.inheritConfig(this.scoreDirectorFactoryConfig, inheritedConfig.getScoreDirectorFactoryConfig());
        this.terminationConfig = ConfigUtils.inheritConfig(this.terminationConfig, inheritedConfig.getTerminationConfig());
        this.phaseConfigList = ConfigUtils.inheritMergeableListConfig(this.phaseConfigList, inheritedConfig.getPhaseConfigList());
    }
}

