/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ComparatorSelectionSorter<Solution_ extends Solution, T>
implements SelectionSorter<Solution_, T> {
    private final Comparator<T> appliedComparator;

    public ComparatorSelectionSorter(Comparator<T> comparator, SelectionSorterOrder selectionSorterOrder) {
        switch (selectionSorterOrder) {
            case ASCENDING: {
                this.appliedComparator = comparator;
                break;
            }
            case DESCENDING: {
                this.appliedComparator = Collections.reverseOrder(comparator);
                break;
            }
            default: {
                throw new IllegalStateException("The selectionSorterOrder (" + (Object)((Object)selectionSorterOrder) + ") is not implemented.");
            }
        }
    }

    @Override
    public void sort(ScoreDirector scoreDirector, List<T> selectionList) {
        Collections.sort(selectionList, this.appliedComparator);
    }
}

