/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablelong;

import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScoreHolder;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.definition.AbstractBendableScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class BendableLongScoreDefinition
extends AbstractBendableScoreDefinition<BendableLongScore> {
    public BendableLongScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(hardLevelsSize, softLevelsSize);
    }

    @Override
    public Class<BendableLongScore> getScoreClass() {
        return BendableLongScore.class;
    }

    @Override
    public BendableLongScore parseScore(String scoreString) {
        return BendableLongScore.parseScore(this.hardLevelsSize, this.softLevelsSize, scoreString);
    }

    @Override
    public BendableLongScore fromLevelNumbers(Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        long[] hardScores = new long[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = (Long)levelNumbers[i];
        }
        long[] softScores = new long[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = (Long)levelNumbers[this.hardLevelsSize + i];
        }
        return BendableLongScore.valueOf(hardScores, softScores);
    }

    public BendableLongScore createScore(long ... scores) {
        int levelsSize = this.hardLevelsSize + this.softLevelsSize;
        if (scores.length != levelsSize) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelsSize (" + levelsSize + ").");
        }
        return BendableLongScore.valueOf(Arrays.copyOfRange(scores, 0, this.hardLevelsSize), Arrays.copyOfRange(scores, this.hardLevelsSize, levelsSize));
    }

    @Override
    public BendableLongScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new BendableLongScoreHolder(constraintMatchEnabled, this.hardLevelsSize, this.softLevelsSize);
    }

    @Override
    public BendableLongScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, BendableLongScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        long[] hardScores = new long[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getHardScore(i) : Long.MAX_VALUE;
        }
        long[] softScores = new long[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getSoftScore(i) : Long.MAX_VALUE;
        }
        return BendableLongScore.valueOf(hardScores, softScores);
    }

    @Override
    public BendableLongScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, BendableLongScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        long[] hardScores = new long[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_UP ? score.getHardScore(i) : Long.MIN_VALUE;
        }
        long[] softScores = new long[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_UP ? score.getSoftScore(i) : Long.MIN_VALUE;
        }
        return BendableLongScore.valueOf(hardScores, softScores);
    }
}

