/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.event;

import java.util.Iterator;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.event.AbstractEventSupport;

public class SolverEventSupport<Solution_ extends Solution>
extends AbstractEventSupport<SolverEventListener<Solution_>> {
    private DefaultSolver<Solution_> solver;

    public SolverEventSupport(DefaultSolver<Solution_> solver) {
        this.solver = solver;
    }

    public void fireBestSolutionChanged(Solution_ newBestSolution, int newUninitializedVariableCount) {
        Iterator it = this.eventListenerSet.iterator();
        if (it.hasNext()) {
            BestSolutionChangedEvent<Solution_> event = new BestSolutionChangedEvent<Solution_>(this.solver, this.solver.getSolverScope().calculateTimeMillisSpent(), newBestSolution, newUninitializedVariableCount);
            do {
                ((SolverEventListener)it.next()).bestSolutionChanged(event);
            } while (it.hasNext());
        }
    }
}

