/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;

public class CalculateCountTermination
extends AbstractTermination {
    private final long calculateCountLimit;

    public CalculateCountTermination(long calculateCountLimit) {
        this.calculateCountLimit = calculateCountLimit;
        if (calculateCountLimit < 0L) {
            throw new IllegalArgumentException("The calculateCountLimit (" + calculateCountLimit + ") cannot be negative.");
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        return this.isTerminated(solverScope.getScoreDirector());
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        return this.isTerminated(phaseScope.getScoreDirector());
    }

    protected boolean isTerminated(InnerScoreDirector scoreDirector) {
        long calculateCount = scoreDirector.getCalculateCount();
        return calculateCount >= this.calculateCountLimit;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return this.calculateTimeGradient(solverScope.getScoreDirector());
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        return this.calculateTimeGradient(phaseScope.getScoreDirector());
    }

    protected double calculateTimeGradient(InnerScoreDirector scoreDirector) {
        long calculateCount = scoreDirector.getCalculateCount();
        double timeGradient = (double)calculateCount / (double)this.calculateCountLimit;
        return Math.min(timeGradient, 1.0);
    }
}

