/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.entity;

import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;

public enum EntitySorterManner {
    NONE,
    DECREASING_DIFFICULTY,
    DECREASING_DIFFICULTY_IF_AVAILABLE;


    public boolean hasSorter(EntityDescriptor entityDescriptor) {
        switch (this) {
            case NONE: {
                return false;
            }
            case DECREASING_DIFFICULTY: {
                return true;
            }
            case DECREASING_DIFFICULTY_IF_AVAILABLE: {
                return entityDescriptor.getDecreasingDifficultySorter() != null;
            }
        }
        throw new IllegalStateException("The sorterManner (" + (Object)((Object)this) + ") is not implemented.");
    }

    public SelectionSorter determineSorter(EntityDescriptor entityDescriptor) {
        switch (this) {
            case NONE: {
                throw new IllegalStateException("Impossible state: hasSorter() should have returned null.");
            }
            case DECREASING_DIFFICULTY: 
            case DECREASING_DIFFICULTY_IF_AVAILABLE: {
                SelectionSorter sorter = entityDescriptor.getDecreasingDifficultySorter();
                if (sorter == null) {
                    throw new IllegalArgumentException("The sorterManner (" + (Object)((Object)this) + ") on entity class (" + entityDescriptor.getEntityClass() + ") fails because that entity class's @" + PlanningEntity.class.getSimpleName() + " annotation does not declare any difficulty comparison.");
                }
                return sorter;
            }
        }
        throw new IllegalStateException("The sorterManner (" + (Object)((Object)this) + ") is not implemented.");
    }
}

