/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.custom;

import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.phase.custom.CustomPhase;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.core.impl.phase.custom.scope.CustomPhaseScope;
import org.optaplanner.core.impl.phase.custom.scope.CustomStepScope;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultCustomPhase<Solution_>
extends AbstractPhase<Solution_>
implements CustomPhase<Solution_> {
    protected List<CustomPhaseCommand<Solution_>> customPhaseCommandList;
    protected boolean forceUpdateBestSolution;
    protected boolean assertStepScoreFromScratch = false;

    public void setCustomPhaseCommandList(List<CustomPhaseCommand<Solution_>> customPhaseCommandList) {
        this.customPhaseCommandList = customPhaseCommandList;
    }

    public void setForceUpdateBestSolution(boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    @Override
    public String getPhaseTypeString() {
        return "Custom";
    }

    @Override
    public void solve(DefaultSolverScope<Solution_> solverScope) {
        CustomPhaseScope<Solution_> phaseScope = new CustomPhaseScope<Solution_>(solverScope);
        this.phaseStarted(phaseScope);
        CustomStepScope<Solution_> stepScope = new CustomStepScope<Solution_>(phaseScope);
        for (CustomPhaseCommand<Solution_> customPhaseCommand : this.customPhaseCommandList) {
            if (this.termination.isPhaseTerminated(phaseScope)) break;
            this.stepStarted(stepScope);
            this.doStep(stepScope, customPhaseCommand);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            stepScope = new CustomStepScope<Solution_>(phaseScope);
        }
        this.phaseEnded(phaseScope);
    }

    @Override
    public void phaseStarted(CustomPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(CustomStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
    }

    private void doStep(CustomStepScope<Solution_> stepScope, CustomPhaseCommand<Solution_> customPhaseCommand) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        customPhaseCommand.changeWorkingSolution(scoreDirector);
        Score score = scoreDirector.calculateScore();
        stepScope.setScore(score);
        if (this.assertStepScoreFromScratch) {
            stepScope.getPhaseScope().assertWorkingScoreFromScratch(stepScope.getScore(), customPhaseCommand);
        }
        this.bestSolutionRecaller.processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void stepEnded(CustomStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        boolean bestScoreImproved = stepScope.getBestScoreImproved();
        if (this.forceUpdateBestSolution && !bestScoreImproved) {
            DefaultSolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
            Object newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
            this.bestSolutionRecaller.updateBestSolution(solverScope, newBestSolution);
        }
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("    Custom step ({}), time spent ({}), score ({}), {} best score ({}).", new Object[]{stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getScore(), bestScoreImproved ? "new" : (this.forceUpdateBestSolution ? "forced" : "   "), phaseScope.getBestScore()});
        }
    }

    @Override
    public void phaseEnded(CustomPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("Custom phase ({}) ended: time spent ({}), best score ({}), score calculation speed ({}/sec), step total ({}).", new Object[]{this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseScoreCalculationSpeed(), phaseScope.getNextStepIndex()});
    }
}

