/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.decider;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import org.optaplanner.core.impl.constructionheuristic.placer.AbstractEntityPlacer;
import org.optaplanner.core.impl.constructionheuristic.placer.Placement;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;

public class ConstructionHeuristicDecider
extends AbstractEntityPlacer {
    protected final Termination termination;
    protected final ConstructionHeuristicForager forager;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    public ConstructionHeuristicDecider(Termination termination, ConstructionHeuristicForager forager) {
        this.termination = termination;
        this.forager = forager;
    }

    public ConstructionHeuristicForager getForager() {
        return this.forager;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.forager.solvingStarted(solverScope);
    }

    public void phaseStarted(ConstructionHeuristicPhaseScope phaseScope) {
        this.forager.phaseStarted(phaseScope);
    }

    public void stepStarted(ConstructionHeuristicStepScope stepScope) {
        this.forager.stepStarted(stepScope);
    }

    public void stepEnded(ConstructionHeuristicStepScope stepScope) {
        this.forager.stepEnded(stepScope);
    }

    public void phaseEnded(ConstructionHeuristicPhaseScope phaseScope) {
        this.forager.phaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.forager.solvingEnded(solverScope);
    }

    public void decideNextStep(ConstructionHeuristicStepScope stepScope, Placement placement) {
        int moveIndex = 0;
        for (Move move : placement) {
            ConstructionHeuristicMoveScope moveScope = new ConstructionHeuristicMoveScope(stepScope);
            moveScope.setMoveIndex(moveIndex);
            ++moveIndex;
            moveScope.setMove(move);
            this.doMove(moveScope);
            if (!this.forager.isQuitEarly() && !this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        stepScope.setSelectedMoveCount(Long.valueOf(moveIndex));
        ConstructionHeuristicMoveScope pickedMoveScope = this.forager.pickMove(stepScope);
        if (pickedMoveScope != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(pickedMoveScope.getUndoMove());
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(ConstructionHeuristicMoveScope moveScope) {
        ScoreDirector scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertExpectedUndoMoveScore) {
            AbstractPhaseScope phaseScope = moveScope.getStepScope().getPhaseScope();
            phaseScope.assertExpectedUndoMoveScore(move, undoMove, ((ConstructionHeuristicPhaseScope)phaseScope).getLastCompletedStepScope().getScore());
        }
        this.logger.trace("        Move index ({}), score ({}), move ({}).", new Object[]{moveScope.getMoveIndex(), moveScope.getScore(), moveScope.getMove()});
    }

    private void processMove(ConstructionHeuristicMoveScope moveScope) {
        Score score = moveScope.getStepScope().getPhaseScope().calculateScore();
        if (this.assertMoveScoreFromScratch) {
            moveScope.getStepScope().getPhaseScope().assertWorkingScoreFromScratch(score, moveScope.getMove());
        }
        moveScope.setScore(score);
        this.forager.addMove(moveScope);
    }
}

