/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class PillarChangeMove<Solution_>
extends AbstractMove {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final List<Object> pillar;
    protected final Object toPlanningValue;

    public PillarChangeMove(List<Object> pillar, GenuineVariableDescriptor<Solution_> variableDescriptor, Object toPlanningValue) {
        this.pillar = pillar;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    public List<Object> getPillar() {
        return this.pillar;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.pillar.get(0));
        if (Objects.equals(oldValue, this.toPlanningValue)) {
            return false;
        }
        if (!this.variableDescriptor.isValueRangeEntityIndependent()) {
            ValueRangeDescriptor valueRangeDescriptor = this.variableDescriptor.getValueRangeDescriptor();
            Object workingSolution = scoreDirector.getWorkingSolution();
            for (Object entity : this.pillar) {
                ValueRange<?> rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution, entity);
                if (rightValueRange.contains(this.toPlanningValue)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.pillar.get(0));
        return new PillarChangeMove<Solution_>(this.pillar, this.variableDescriptor, oldValue);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        for (Object entity : this.pillar) {
            scoreDirector.beforeVariableChanged(this.variableDescriptor, entity);
            this.variableDescriptor.setValue(entity, this.toPlanningValue);
            scoreDirector.afterVariableChanged(this.variableDescriptor, entity);
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.pillar;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PillarChangeMove) {
            PillarChangeMove other = (PillarChangeMove)o;
            return new EqualsBuilder().append(this.variableDescriptor, other.variableDescriptor).append(this.pillar, other.pillar).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.variableDescriptor).append(this.pillar).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        Object oldValue = this.variableDescriptor.getValue(this.pillar.get(0));
        return this.pillar.toString() + " {" + oldValue + " -> " + this.toPlanningValue + "}";
    }
}

