/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.fact;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.BeanPropertyMemberAccessor;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenEnumValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenExistingInstanceValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenListValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenMapValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenNullValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenParsedValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenPrimitiveValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenStringValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenValueProvider;

public class TestGenValueFact
implements TestGenFact {
    private final Object instance;
    private final String variableName;
    private final HashMap<BeanPropertyMemberAccessor, TestGenValueProvider> attributes = new HashMap();
    private final List<TestGenFact> dependencies = new ArrayList<TestGenFact>();
    private final List<Class<?>> imports = new ArrayList();

    public TestGenValueFact(int id, Object instance) {
        this.instance = instance;
        this.variableName = instance.getClass().getSimpleName().substring(0, 1).toLowerCase() + instance.getClass().getSimpleName().substring(1) + "_" + id;
    }

    @Override
    public void setUp(Map<Object, TestGenFact> existingInstances) {
        for (Field field : this.instance.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            Method setter = ReflectionHelper.getSetterMethod(this.instance.getClass(), field.getType(), fieldName);
            Method getter = ReflectionHelper.getGetterMethod(this.instance.getClass(), fieldName);
            if (setter == null || getter == null) continue;
            BeanPropertyMemberAccessor accessor = new BeanPropertyMemberAccessor(getter);
            Object value = accessor.executeGetter(this.instance);
            if (value != null) {
                Type[] typeArgs;
                String id;
                if (field.getType().equals(String.class)) {
                    this.attributes.put(accessor, new TestGenStringValueProvider(value));
                    continue;
                }
                if (field.getType().isPrimitive()) {
                    this.attributes.put(accessor, new TestGenPrimitiveValueProvider(value));
                    continue;
                }
                if (field.getType().isEnum()) {
                    this.attributes.put(accessor, new TestGenEnumValueProvider(value));
                    continue;
                }
                if (existingInstances.containsKey(value)) {
                    this.attributes.put(accessor, new TestGenExistingInstanceValueProvider(value, existingInstances.get(value).toString()));
                    this.dependencies.add(existingInstances.get(value));
                    this.imports.add(value.getClass());
                    continue;
                }
                if (field.getType().equals(List.class)) {
                    id = this.variableName + "_" + field.getName();
                    typeArgs = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                    TestGenListValueProvider listValueProvider = new TestGenListValueProvider(value, id, typeArgs[0], existingInstances);
                    this.attributes.put(accessor, listValueProvider);
                    this.dependencies.addAll(listValueProvider.getFacts());
                    this.imports.addAll(listValueProvider.getImports());
                    continue;
                }
                if (field.getType().equals(Map.class)) {
                    id = this.variableName + "_" + field.getName();
                    typeArgs = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                    TestGenMapValueProvider mapValueProvider = new TestGenMapValueProvider(value, id, typeArgs, existingInstances);
                    this.attributes.put(accessor, mapValueProvider);
                    this.dependencies.addAll(mapValueProvider.getFacts());
                    this.imports.addAll(mapValueProvider.getImports());
                    continue;
                }
                Method parseMethod = TestGenValueFact.getParseMethod(field);
                if (parseMethod != null) {
                    this.attributes.put(accessor, new TestGenParsedValueProvider(parseMethod, value));
                    this.imports.add(value.getClass());
                    continue;
                }
                throw new IllegalStateException("Unsupported type: " + field.getType());
            }
            this.attributes.put(accessor, new TestGenNullValueProvider());
        }
    }

    private static Method getParseMethod(Field f) {
        for (Method m : f.getType().getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !f.getType().equals(m.getReturnType()) || m.getParameters().length != 1 || !m.getParameters()[0].getType().equals(String.class) || !m.getName().startsWith("parse") && !m.getName().startsWith("valueOf")) continue;
            return m;
        }
        return null;
    }

    @Override
    public List<TestGenFact> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Class<?>> getImports() {
        return this.imports;
    }

    @Override
    public void reset() {
        for (Map.Entry<BeanPropertyMemberAccessor, TestGenValueProvider> entry : this.attributes.entrySet()) {
            BeanPropertyMemberAccessor accessor = entry.getKey();
            TestGenValueProvider value = entry.getValue();
            accessor.executeSetter(this.instance, value.get());
        }
    }

    @Override
    public void printInitialization(StringBuilder sb) {
        sb.append(String.format("    %s %s = new %s();%n", this.instance.getClass().getSimpleName(), this.variableName, this.instance.getClass().getSimpleName()));
    }

    @Override
    public void printSetup(StringBuilder sb) {
        sb.append(String.format("        //%s%n", this.instance));
        for (Map.Entry<BeanPropertyMemberAccessor, TestGenValueProvider> entry : this.attributes.entrySet()) {
            BeanPropertyMemberAccessor accessor = entry.getKey();
            Method setter = ReflectionHelper.getSetterMethod(this.instance.getClass(), accessor.getType(), accessor.getName());
            TestGenValueProvider value = entry.getValue();
            value.printSetup(sb);
            if (value.get() == null) continue;
            sb.append(String.format("        %s.%s(%s);%n", this.variableName, setter.getName(), value.toString()));
        }
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    public String toString() {
        return this.variableName;
    }
}

