/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.reproducer;

import org.kie.api.runtime.KieSession;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionListener;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenCorruptedScoreException;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenOriginalProblemReproducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenCorruptedScoreReproducer
implements TestGenOriginalProblemReproducer,
TestGenKieSessionListener {
    private static final Logger log = LoggerFactory.getLogger(TestGenCorruptedScoreReproducer.class);
    private final String analysis;
    private final KieSession originalKieSession;
    private final ScoreDefinition<?> scoreDefinition;
    private final boolean constraintMatchEnabledPreference;

    public TestGenCorruptedScoreReproducer(String analysis, KieSession originalKieSession, ScoreDefinition<?> scoreDefinition, boolean constraintMatchEnabledPreference) {
        this.analysis = analysis;
        this.originalKieSession = originalKieSession;
        this.scoreDefinition = scoreDefinition;
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
    }

    private static Score<?> extractScore(KieSession kieSession) {
        ScoreHolder sh = (ScoreHolder)kieSession.getGlobal("scoreHolder");
        return sh.extractScore(0);
    }

    private KieSession createKieSession() {
        KieSession newKieSession = this.originalKieSession.getKieBase().newKieSession();
        for (String globalKey : this.originalKieSession.getGlobals().getGlobalKeys()) {
            newKieSession.setGlobal(globalKey, this.originalKieSession.getGlobal(globalKey));
        }
        if (this.scoreDefinition != null) {
            ScoreHolder sh = this.scoreDefinition.buildScoreHolder(this.constraintMatchEnabledPreference);
            newKieSession.setGlobal("scoreHolder", (Object)sh);
        }
        return newKieSession;
    }

    @Override
    public boolean isReproducible(TestGenKieSessionJournal journal) {
        journal.addListener(this);
        try {
            journal.replay(this.createKieSession());
            return false;
        }
        catch (TestGenCorruptedScoreException e) {
            return true;
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("No fact handle for ")) {
                log.debug("    Can't remove insert: {}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            } else {
                log.info("Unexpected exception", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public void assertReproducible(TestGenKieSessionJournal journal, String message) {
        if (!this.isReproducible(journal)) {
            throw new IllegalStateException(message + " The score is not corrupted.");
        }
    }

    @Override
    public void afterFireAllRules(KieSession kieSession) {
        KieSession uncorruptedSession = this.createKieSession();
        for (Object object : kieSession.getObjects()) {
            uncorruptedSession.insert(object);
        }
        uncorruptedSession.fireAllRules();
        uncorruptedSession.dispose();
        Score<?> uncorruptedScore = TestGenCorruptedScoreReproducer.extractScore(uncorruptedSession);
        Score<?> workingScore = TestGenCorruptedScoreReproducer.extractScore(kieSession);
        if (!workingScore.equals(uncorruptedScore)) {
            log.debug("    Score: working[{}], uncorrupted[{}]", workingScore, uncorruptedScore);
            throw new TestGenCorruptedScoreException("Working: " + workingScore + ", uncorrupted: " + uncorruptedScore);
        }
    }

    public String toString() {
        return this.analysis;
    }
}

