/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftlong;

import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftLongScoreHolder
extends AbstractScoreHolder {
    protected long hardScore;
    protected long softScore;

    public HardSoftLongScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final long weight) {
        this.hardScore += weight;
        this.registerLongConstraintMatch(kcontext, 0, weight, new AbstractScoreHolder.LongConstraintUndoListener(){

            @Override
            public void undo() {
                HardSoftLongScoreHolder.this.hardScore -= weight;
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final long weight) {
        this.softScore += weight;
        this.registerLongConstraintMatch(kcontext, 1, weight, new AbstractScoreHolder.LongConstraintUndoListener(){

            @Override
            public void undo() {
                HardSoftLongScoreHolder.this.softScore -= weight;
            }
        });
    }

    @Override
    public Score extractScore(int initScore) {
        return HardSoftLongScore.valueOf(initScore, this.hardScore, this.softScore);
    }
}

