/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainReversingSwapMove
extends AbstractMove {
    private final GenuineVariableDescriptor variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    private final SubChain leftSubChain;
    private final SubChain rightSubChain;

    public SubChainReversingSwapMove(GenuineVariableDescriptor variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, SubChain leftSubChain, SubChain rightSubChain) {
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.leftSubChain = leftSubChain;
        this.rightSubChain = rightSubChain;
    }

    public SubChain getLeftSubChain() {
        return this.leftSubChain;
    }

    public SubChain getRightSubChain() {
        return this.rightSubChain;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (Object leftEntity : this.leftSubChain.getEntityList()) {
            if (!this.rightSubChain.getEntityList().contains(leftEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new SubChainReversingSwapMove(this.variableDescriptor, this.inverseVariableSupply, this.rightSubChain.reverse(), this.leftSubChain.reverse());
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        Object leftFirstEntity = this.leftSubChain.getFirstEntity();
        Object leftFirstValue = this.variableDescriptor.getValue(leftFirstEntity);
        Object leftLastEntity = this.leftSubChain.getLastEntity();
        Object leftTrailingLastEntity = this.inverseVariableSupply.getInverseSingleton(leftLastEntity);
        Object rightFirstEntity = this.rightSubChain.getFirstEntity();
        Object rightFirstValue = this.variableDescriptor.getValue(rightFirstEntity);
        Object rightLastEntity = this.rightSubChain.getLastEntity();
        Object rightTrailingLastEntity = this.inverseVariableSupply.getInverseSingleton(rightLastEntity);
        Object leftLastEntityValue = this.variableDescriptor.getValue(leftLastEntity);
        Object rightLastEntityValue = this.variableDescriptor.getValue(rightLastEntity);
        if (leftLastEntity != rightFirstValue) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, leftLastEntity, rightFirstValue);
        }
        if (rightLastEntity != leftFirstValue) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, rightLastEntity, leftFirstValue);
        }
        this.reverseChain(scoreDirector, leftLastEntity, leftLastEntityValue, leftFirstEntity);
        this.reverseChain(scoreDirector, rightLastEntity, rightLastEntityValue, rightFirstEntity);
        if (leftTrailingLastEntity != null) {
            if (leftTrailingLastEntity != rightFirstEntity) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, leftTrailingLastEntity, rightFirstEntity);
            } else {
                scoreDirector.changeVariableFacade(this.variableDescriptor, leftLastEntity, rightFirstEntity);
            }
        }
        if (rightTrailingLastEntity != null) {
            if (rightTrailingLastEntity != leftFirstEntity) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, rightTrailingLastEntity, leftFirstEntity);
            } else {
                scoreDirector.changeVariableFacade(this.variableDescriptor, rightLastEntity, leftFirstEntity);
            }
        }
    }

    private void reverseChain(ScoreDirector scoreDirector, Object entity, Object previous, Object toEntity) {
        while (entity != toEntity) {
            Object value = this.variableDescriptor.getValue(previous);
            scoreDirector.changeVariableFacade(this.variableDescriptor, previous, entity);
            entity = previous;
            previous = value;
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftSubChain.getSize() + this.rightSubChain.getSize());
        entities.addAll(this.leftSubChain.getEntityList());
        entities.addAll(this.rightSubChain.getEntityList());
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity()));
        values.add(this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity()));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainReversingSwapMove) {
            SubChainReversingSwapMove other = (SubChainReversingSwapMove)o;
            return new EqualsBuilder().append((Object)this.variableDescriptor, (Object)other.variableDescriptor).append((Object)this.leftSubChain, (Object)other.leftSubChain).append((Object)this.rightSubChain, (Object)other.rightSubChain).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.variableDescriptor).append((Object)this.leftSubChain).append((Object)this.rightSubChain).toHashCode();
    }

    public String toString() {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        return this.leftSubChain.toDottedString() + " {" + oldLeftValue + "} <-reversing-> " + this.rightSubChain.toDottedString() + " {" + oldRightValue + "}";
    }
}

