/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleSupport;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhase<Solution_>
implements Phase<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int phaseIndex = -1;
    protected Termination termination;
    protected BestSolutionRecaller<Solution_> bestSolutionRecaller;
    protected PhaseLifecycleSupport<Solution_> solverPhaseLifecycleSupport;
    protected PhaseLifecycleSupport<Solution_> phaseLifecycleSupport = new PhaseLifecycleSupport();
    protected boolean assertStepScoreFromScratch = false;
    protected boolean assertExpectedStepScore = false;
    protected boolean assertShadowVariablesAreNotStaleAfterStep = false;

    public Termination getTermination() {
        return this.termination;
    }

    public int getPhaseIndex() {
        return this.phaseIndex;
    }

    public void setPhaseIndex(int phaseIndex) {
        this.phaseIndex = phaseIndex;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller<Solution_> bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
    }

    @Override
    public void setSolverPhaseLifecycleSupport(PhaseLifecycleSupport<Solution_> solverPhaseLifecycleSupport) {
        this.solverPhaseLifecycleSupport = solverPhaseLifecycleSupport;
    }

    public boolean isAssertStepScoreFromScratch() {
        return this.assertStepScoreFromScratch;
    }

    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    public boolean isAssertExpectedStepScore() {
        return this.assertExpectedStepScore;
    }

    public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
        this.assertExpectedStepScore = assertExpectedStepScore;
    }

    public boolean isAssertShadowVariablesAreNotStaleAfterStep() {
        return this.assertShadowVariablesAreNotStaleAfterStep;
    }

    public void setAssertShadowVariablesAreNotStaleAfterStep(boolean assertShadowVariablesAreNotStaleAfterStep) {
        this.assertShadowVariablesAreNotStaleAfterStep = assertShadowVariablesAreNotStaleAfterStep;
    }

    public abstract String getPhaseTypeString();

    @Override
    public void solvingStarted(DefaultSolverScope<Solution_> solverScope) {
        this.termination.solvingStarted(solverScope);
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope<Solution_> solverScope) {
        this.termination.solvingEnded(solverScope);
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        phaseScope.startingNow();
        phaseScope.reset();
        this.bestSolutionRecaller.phaseStarted(phaseScope);
        this.solverPhaseLifecycleSupport.firePhaseStarted(phaseScope);
        this.termination.phaseStarted(phaseScope);
        this.phaseLifecycleSupport.firePhaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        this.bestSolutionRecaller.stepStarted(stepScope);
        this.solverPhaseLifecycleSupport.fireStepStarted(stepScope);
        this.termination.stepStarted(stepScope);
        this.phaseLifecycleSupport.fireStepStarted(stepScope);
    }

    protected void predictWorkingStepScore(AbstractStepScope<Solution_> stepScope, Object completedAction) {
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        phaseScope.getSolutionDescriptor().setScore(phaseScope.getWorkingSolution(), stepScope.getScore());
        if (this.assertStepScoreFromScratch) {
            phaseScope.assertWorkingScoreFromScratch(stepScope.getScore(), completedAction);
        }
        if (this.assertExpectedStepScore) {
            phaseScope.assertExpectedWorkingScore(stepScope.getScore(), completedAction);
        }
        if (this.assertShadowVariablesAreNotStaleAfterStep) {
            phaseScope.assertShadowVariablesAreNotStale(stepScope.getScore(), completedAction);
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        this.bestSolutionRecaller.stepEnded(stepScope);
        this.solverPhaseLifecycleSupport.fireStepEnded(stepScope);
        this.termination.stepEnded(stepScope);
        this.phaseLifecycleSupport.fireStepEnded(stepScope);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        this.bestSolutionRecaller.phaseEnded(phaseScope);
        this.solverPhaseLifecycleSupport.firePhaseEnded(phaseScope);
        this.termination.phaseEnded(phaseScope);
        this.phaseLifecycleSupport.firePhaseEnded(phaseScope);
    }

    @Override
    public void addPhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.addEventListener(phaseLifecycleListener);
    }

    @Override
    public void removePhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.removeEventListener(phaseLifecycleListener);
    }

    protected void assertWorkingSolutionInitialized(AbstractPhaseScope<Solution_> phaseScope) {
        if (!phaseScope.getStartingScore().isSolutionInitialized()) {
            InnerScoreDirector<Solution_> scoreDirector = phaseScope.getScoreDirector();
            SolutionDescriptor solutionDescriptor = scoreDirector.getSolutionDescriptor();
            Object workingSolution = scoreDirector.getWorkingSolution();
            Iterator<Object> it = solutionDescriptor.extractAllEntitiesIterator(workingSolution);
            while (it.hasNext()) {
                Object entity = it.next();
                if (solutionDescriptor.isEntityInitializedOrImmovable(scoreDirector, entity)) continue;
                EntityDescriptor<Solution_> entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
                String variableRef = null;
                for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptors()) {
                    if (variableDescriptor.isInitialized(entity)) continue;
                    variableRef = variableDescriptor.getSimpleEntityAndVariableName();
                    break;
                }
                throw new IllegalStateException(this.getPhaseTypeString() + " phase (" + this.phaseIndex + ") needs to start from an initialized solution, but the planning variable (" + variableRef + ") is uninitialized for the entity (" + entity + ").\n  Initialize the solution by configuring a Construction Heuristic phase before this phase.");
            }
        }
    }
}

