/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.List;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleSupport;
import org.optaplanner.core.impl.solver.event.SolverEventSupport;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;

public abstract class AbstractSolver<Solution_>
implements Solver<Solution_> {
    protected final SolverEventSupport<Solution_> solverEventSupport = new SolverEventSupport(this);
    protected final PhaseLifecycleSupport<Solution_> phaseLifecycleSupport = new PhaseLifecycleSupport();
    protected final Termination termination;
    protected final BestSolutionRecaller<Solution_> bestSolutionRecaller;
    protected final List<Phase<Solution_>> phaseList;

    public AbstractSolver(Termination termination, BestSolutionRecaller<Solution_> bestSolutionRecaller, List<Phase<Solution_>> phaseList) {
        this.termination = termination;
        this.bestSolutionRecaller = bestSolutionRecaller;
        bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
        this.phaseList = phaseList;
        for (Phase<Solution_> phase : phaseList) {
            phase.setSolverPhaseLifecycleSupport(this.phaseLifecycleSupport);
        }
    }

    public void solvingStarted(DefaultSolverScope<Solution_> solverScope) {
        solverScope.setWorkingSolutionFromBestSolution();
        this.bestSolutionRecaller.solvingStarted(solverScope);
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
        for (Phase<Solution_> phase : this.phaseList) {
            phase.solvingStarted(solverScope);
        }
    }

    public void solvingEnded(DefaultSolverScope<Solution_> solverScope) {
        for (Phase<Solution_> phase : this.phaseList) {
            phase.solvingEnded(solverScope);
        }
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
        this.bestSolutionRecaller.solvingEnded(solverScope);
    }

    @Override
    public void addEventListener(SolverEventListener<Solution_> eventListener) {
        this.solverEventSupport.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(SolverEventListener<Solution_> eventListener) {
        this.solverEventSupport.removeEventListener(eventListener);
    }

    public void addPhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.addEventListener(phaseLifecycleListener);
    }

    public void removePhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.removeEventListener(phaseLifecycleListener);
    }
}

