/*
 * Copyright 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaplanner.core.config.heuristic.selector.common.decorator;

import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;

/**
 * @see SelectionSorter
 */
public enum SelectionSorterOrder {
    /**
     * For example: 0, 1, 2, 3.
     */
    ASCENDING,
    /**
     * For example: 3, 2, 1, 0.
     */
    DESCENDING;

    public static SelectionSorterOrder resolve(SelectionSorterOrder sorterOrder) {
        if (sorterOrder == null) {
            return ASCENDING;
        } else {
            return sorterOrder;
        }
    }

}
