/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftlong;

import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftLongScoreHolder
extends AbstractScoreHolder {
    protected long hardScore;
    protected long softScore;

    public HardSoftLongScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardSoftLongScore.ZERO);
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, long hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardSoftLongScore.valueOf(hardWeight, 0L));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, long softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardSoftLongScore.valueOf(0L, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, long hardWeight, long softWeight) {
        this.hardScore += hardWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.softScore -= softWeight;
        }, () -> HardSoftLongScore.valueOf(hardWeight, softWeight));
    }

    @Override
    public Score extractScore(int initScore) {
        return HardSoftLongScore.valueOfUninitialized(initScore, this.hardScore, this.softScore);
    }
}

