/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public abstract class AbstractConfig<C extends AbstractConfig> {
    public C newInstance() {
        Class<?> configClass = this.getClass();
        try {
            return (C)((AbstractConfig)configClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("The configClass (" + configClass + ") does not have a public no-arg constructor.\nThis is a bug, please report an issue with this stacktrace.", e);
        }
    }

    protected EntityDescriptor deduceEntityDescriptor(SolutionDescriptor solutionDescriptor, Class<?> entityClass) {
        EntityDescriptor entityDescriptor;
        if (entityClass != null) {
            entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(entityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The config (" + this + ") has an entityClass (" + entityClass + ") that is not a known planning entity.\nCheck your solver configuration. If that class (" + entityClass.getSimpleName() + ") is not in the entityClassSet (" + solutionDescriptor.getEntityClassSet() + "), check your " + PlanningSolution.class.getSimpleName() + " implementation's annotated methods too.");
            }
        } else {
            Collection entityDescriptors = solutionDescriptor.getGenuineEntityDescriptors();
            if (entityDescriptors.size() != 1) {
                throw new IllegalArgumentException("The config (" + this + ") has no entityClass (" + entityClass + ") configured and because there are multiple in the entityClassSet (" + solutionDescriptor.getEntityClassSet() + "), it can not be deducted automatically.");
            }
            entityDescriptor = entityDescriptors.iterator().next();
        }
        return entityDescriptor;
    }

    protected GenuineVariableDescriptor deduceVariableDescriptor(EntityDescriptor entityDescriptor, String variableName) {
        GenuineVariableDescriptor variableDescriptor;
        if (variableName != null) {
            variableDescriptor = entityDescriptor.getGenuineVariableDescriptor(variableName);
            if (variableDescriptor == null) {
                throw new IllegalArgumentException("The config (" + this + ") has a variableName (" + variableName + ") which is not a valid planning variable on entityClass (" + entityDescriptor.getEntityClass() + ").\n" + entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
            }
        } else {
            Collection variableDescriptors = entityDescriptor.getGenuineVariableDescriptors();
            if (variableDescriptors.size() != 1) {
                throw new IllegalArgumentException("The config (" + this + ") has no configured variableName (" + variableName + ") for entityClass (" + entityDescriptor.getEntityClass() + ") and because there are multiple variableNames (" + entityDescriptor.getGenuineVariableNameSet() + "), it can not be deducted automatically.");
            }
            variableDescriptor = variableDescriptors.iterator().next();
        }
        return variableDescriptor;
    }

    protected List<GenuineVariableDescriptor> deduceVariableDescriptorList(EntityDescriptor entityDescriptor, List<String> variableNameIncludeList) {
        List<GenuineVariableDescriptor> variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList();
        if (variableNameIncludeList == null) {
            return variableDescriptorList;
        }
        ArrayList<GenuineVariableDescriptor> resolvedVariableDescriptorList = new ArrayList<GenuineVariableDescriptor>(variableDescriptorList.size());
        for (String variableNameInclude : variableNameIncludeList) {
            boolean found = false;
            for (GenuineVariableDescriptor variableDescriptor : variableDescriptorList) {
                if (!variableDescriptor.getVariableName().equals(variableNameInclude)) continue;
                resolvedVariableDescriptorList.add(variableDescriptor);
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("The config (" + this + ") has a variableNameInclude (" + variableNameInclude + ") which does not exist in the entity (" + entityDescriptor.getEntityClass() + ")'s variableDescriptorList (" + variableDescriptorList + ").");
        }
        return resolvedVariableDescriptorList;
    }

    public abstract void inherit(C var1);

    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }
}

