/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import java.util.Arrays;
import org.optaplanner.core.api.score.AbstractBendableScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class BendableScore
extends AbstractBendableScore<BendableScore>
implements FeasibilityScore<BendableScore> {
    private final int[] hardScores;
    private final int[] softScores;

    public static BendableScore parseScore(String scoreString) {
        String[][] scoreTokens = BendableScore.parseBendableScoreTokens(BendableScore.class, scoreString);
        int initScore = BendableScore.parseInitScore(BendableScore.class, scoreString, scoreTokens[0][0]);
        int[] hardScores = new int[scoreTokens[1].length];
        for (int i = 0; i < hardScores.length; ++i) {
            hardScores[i] = BendableScore.parseLevelAsInt(BendableScore.class, scoreString, scoreTokens[1][i]);
        }
        int[] softScores = new int[scoreTokens[2].length];
        for (int i = 0; i < softScores.length; ++i) {
            softScores[i] = BendableScore.parseLevelAsInt(BendableScore.class, scoreString, scoreTokens[2][i]);
        }
        return BendableScore.valueOfUninitialized(initScore, hardScores, softScores);
    }

    public static BendableScore valueOfUninitialized(int initScore, int[] hardScores, int[] softScores) {
        return new BendableScore(initScore, hardScores, softScores);
    }

    public static BendableScore valueOf(int[] hardScores, int[] softScores) {
        return new BendableScore(0, hardScores, softScores);
    }

    public static BendableScore zero(int hardLevelsSize, int softLevelsSize) {
        return new BendableScore(0, new int[hardLevelsSize], new int[softLevelsSize]);
    }

    private BendableScore() {
        super(Integer.MIN_VALUE);
        this.hardScores = null;
        this.softScores = null;
    }

    protected BendableScore(int initScore, int[] hardScores, int[] softScores) {
        super(initScore);
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    public int[] getHardScores() {
        return Arrays.copyOf(this.hardScores, this.hardScores.length);
    }

    public int[] getSoftScores() {
        return Arrays.copyOf(this.softScores, this.softScores.length);
    }

    @Override
    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public int getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    @Override
    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public int getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Override
    public BendableScore toInitializedScore() {
        return this.initScore == 0 ? this : new BendableScore(0, this.hardScores, this.softScores);
    }

    @Override
    public BendableScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new BendableScore(newInitScore, this.hardScores, this.softScores);
    }

    @Override
    public int getLevelsSize() {
        return this.hardScores.length + this.softScores.length;
    }

    public int getHardOrSoftScore(int level) {
        if (level < this.hardScores.length) {
            return this.hardScores[level];
        }
        return this.softScores[level - this.hardScores.length];
    }

    @Override
    public boolean isFeasible() {
        if (this.initScore < 0) {
            return false;
        }
        for (int hardScore : this.hardScores) {
            if (hardScore >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableScore add(BendableScore augment) {
        int i;
        this.validateCompatible(augment);
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] + augment.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] + augment.getSoftScore(i);
        }
        return new BendableScore(this.initScore + augment.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore subtract(BendableScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] - subtrahend.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] - subtrahend.getSoftScore(i);
        }
        return new BendableScore(this.initScore - subtrahend.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore multiply(double multiplicand) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor((double)this.hardScores[i] * multiplicand);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor((double)this.softScores[i] * multiplicand);
        }
        return new BendableScore((int)Math.floor((double)this.initScore * multiplicand), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore divide(double divisor) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor((double)this.hardScores[i] / divisor);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor((double)this.softScores[i] / divisor);
        }
        return new BendableScore((int)Math.floor((double)this.initScore / divisor), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore power(double exponent) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor(Math.pow(this.hardScores[i], exponent));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor(Math.pow(this.softScores[i], exponent));
        }
        return new BendableScore((int)Math.floor(Math.pow(this.initScore, exponent)), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore negate() {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = -this.hardScores[i];
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = -this.softScores[i];
        }
        return new BendableScore(-this.initScore, newHardScores, newSoftScores);
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BendableScore) {
            int i;
            BendableScore other = (BendableScore)o;
            if (this.getHardLevelsSize() != other.getHardLevelsSize() || this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
                return false;
            }
            if (this.initScore != other.getInitScore()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i] == other.getHardScore(i)) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i] == other.getSoftScore(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 629 + this.initScore;
        hashCode = 37 * hashCode + Arrays.hashCode(this.hardScores);
        hashCode = 37 * hashCode + Arrays.hashCode(this.softScores);
        return hashCode;
    }

    @Override
    public int compareTo(BendableScore other) {
        int i;
        this.validateCompatible(other);
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            if (this.hardScores[i] == other.getHardScore(i)) continue;
            return this.hardScores[i] < other.getHardScore(i) ? -1 : 1;
        }
        for (i = 0; i < this.softScores.length; ++i) {
            if (this.softScores[i] == other.getSoftScore(i)) continue;
            return this.softScores[i] < other.getSoftScore(i) ? -1 : 1;
        }
        return 0;
    }

    @Override
    public String toShortString() {
        return this.buildBendableShortString(n -> (Integer)n != 0);
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 13);
        s.append(this.getInitPrefix());
        s.append("[");
        boolean first = true;
        for (int hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        s.append("]hard/[");
        first = true;
        for (int softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        s.append("]soft");
        return s.toString();
    }

    public void validateCompatible(BendableScore other) {
        if (this.getHardLevelsSize() != other.getHardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.getHardLevelsSize() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.getHardLevelsSize() + ").");
        }
        if (this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.getSoftLevelsSize() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.getSoftLevelsSize() + ").");
        }
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        if (!(otherScore instanceof BendableScore)) {
            return false;
        }
        BendableScore otherBendableScore = (BendableScore)otherScore;
        return this.hardScores.length == otherBendableScore.hardScores.length && this.softScores.length == otherBendableScore.softScores.length;
    }
}

