/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablelong;

import java.util.Arrays;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableLongScoreHolder
extends AbstractScoreHolder {
    private long[] hardScores;
    private long[] softScores;

    public BendableLongScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled, BendableLongScore.zero(hardLevelsSize, softLevelsSize));
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public long getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public long getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, long weight) {
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = hardLevel;
            this.hardScores[n] = this.hardScores[n] - weight;
        }, () -> {
            long[] newHardScores = new long[this.hardScores.length];
            long[] newSoftScores = new long[this.softScores.length];
            newHardScores[hardLevel] = weight;
            return BendableLongScore.valueOf(newHardScores, newSoftScores);
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, long weight) {
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = softLevel;
            this.softScores[n] = this.softScores[n] - weight;
        }, () -> {
            long[] newHardScores = new long[this.hardScores.length];
            long[] newSoftScores = new long[this.softScores.length];
            newSoftScores[softLevel] = weight;
            return BendableLongScore.valueOf(newHardScores, newSoftScores);
        });
    }

    public void addMultiConstraintMatch(RuleContext kcontext, long[] hardWeights, long[] softWeights) {
        int i;
        if (this.hardScores.length != hardWeights.length) {
            throw new IllegalArgumentException("The hardScores length (" + this.hardScores.length + ") is different than the hardWeights length (" + hardWeights.length + ").");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            int n = i;
            this.hardScores[n] = this.hardScores[n] + hardWeights[i];
        }
        if (this.softScores.length != softWeights.length) {
            throw new IllegalArgumentException("The softScores length (" + this.softScores.length + ") is different than the softWeights length (" + softWeights.length + ").");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            int n = i;
            this.softScores[n] = this.softScores[n] + softWeights[i];
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                int n = i;
                this.hardScores[n] = this.hardScores[n] - hardWeights[i];
            }
            for (i = 0; i < this.softScores.length; ++i) {
                int n = i;
                this.softScores[n] = this.softScores[n] - softWeights[i];
            }
        }, () -> BendableLongScore.valueOf(hardWeights, softWeights));
    }

    @Override
    public Score extractScore(int initScore) {
        return new BendableLongScore(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

