/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftlong;

import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardMediumSoftLongScoreHolder
extends AbstractScoreHolder {
    protected long hardScore;
    protected long mediumScore;
    protected long softScore;

    public HardMediumSoftLongScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftLongScore.ZERO);
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getMediumScore() {
        return this.mediumScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, long hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardMediumSoftLongScore.valueOf(hardWeight, 0L, 0L));
    }

    public void addMediumConstraintMatch(RuleContext kcontext, long mediumWeight) {
        this.mediumScore += mediumWeight;
        this.registerConstraintMatch(kcontext, () -> this.mediumScore -= mediumWeight, () -> HardMediumSoftLongScore.valueOf(0L, mediumWeight, 0L));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, long softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardMediumSoftLongScore.valueOf(0L, 0L, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, long hardWeight, long mediumWeight, long softWeight) {
        this.hardScore += hardWeight;
        this.mediumScore += mediumWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.mediumScore -= mediumWeight;
            this.softScore -= softWeight;
        }, () -> HardMediumSoftLongScore.valueOf(hardWeight, mediumWeight, softWeight));
    }

    @Override
    public Score extractScore(int initScore) {
        return HardMediumSoftLongScore.valueOfUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }
}

