/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.partitionedsearch;

import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.AbstractSolver;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;

public class PartitionSolver<Solution_>
extends AbstractSolver<Solution_> {
    protected final DefaultSolverScope<Solution_> solverScope;

    public PartitionSolver(Termination termination, BestSolutionRecaller<Solution_> bestSolutionRecaller, List<Phase<Solution_>> phaseList, DefaultSolverScope<Solution_> solverScope) {
        super(termination, bestSolutionRecaller, phaseList);
        this.solverScope = solverScope;
    }

    @Override
    public InnerScoreDirectorFactory<Solution_> getScoreDirectorFactory() {
        return this.solverScope.getScoreDirector().getScoreDirectorFactory();
    }

    @Override
    public Solution_ getBestSolution() {
        return this.solverScope.getBestSolution();
    }

    @Override
    public Score getBestScore() {
        return this.solverScope.getBestScore();
    }

    @Override
    public long getTimeMillisSpent() {
        Long endingSystemTimeMillis = this.solverScope.getEndingSystemTimeMillis();
        if (endingSystemTimeMillis == null) {
            endingSystemTimeMillis = System.currentTimeMillis();
        }
        return endingSystemTimeMillis - this.solverScope.getStartingSystemTimeMillis();
    }

    @Override
    public boolean isSolving() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean terminateEarly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTerminateEarly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addProblemFactChange(ProblemFactChange<Solution_> problemFactChange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addProblemFactChanges(List<ProblemFactChange<Solution_>> problemFactChanges) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEveryProblemFactChangeProcessed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Solution_ solve(Solution_ part) {
        this.solverScope.initializeYielding();
        try {
            this.solverScope.setBestSolution(part);
            this.solvingStarted(this.solverScope);
            this.runPhases(this.solverScope);
            this.solvingEnded(this.solverScope);
            Solution_ Solution_ = this.solverScope.getBestSolution();
            return Solution_;
        }
        finally {
            this.solverScope.destroyYielding();
        }
    }

    @Override
    public void solvingStarted(DefaultSolverScope<Solution_> solverScope) {
        solverScope.setWorkingSolutionFromBestSolution();
        super.solvingStarted(solverScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        solverScope.endingNow();
        solverScope.getScoreDirector().dispose();
    }
}

