/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config;

import org.kie.api.runtime.KieContainer;

public class SolverConfigContext {
    private final ClassLoader classLoader;
    private final KieContainer kieContainer;

    public SolverConfigContext() {
        this.classLoader = null;
        this.kieContainer = null;
    }

    public SolverConfigContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.kieContainer = null;
    }

    public SolverConfigContext(KieContainer kieContainer) {
        this.classLoader = null;
        this.kieContainer = kieContainer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public ClassLoader determineActualClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.kieContainer != null) {
            return this.kieContainer.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public void validate() {
        if (this.classLoader != null && this.kieContainer != null) {
            throw new IllegalStateException("The classLoader (" + this.classLoader + ") and kieContainer (" + this.kieContainer + ") cannot both be configured because the " + KieContainer.class.getSimpleName() + " already has a " + ClassLoader.class.getSimpleName() + ".");
        }
    }
}

