/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableBigDecimalScoreHolder
extends AbstractScoreHolder<BendableBigDecimalScore> {
    protected final Map<Rule, BiConsumer<RuleContext, BigDecimal>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, BigDecimal>>();
    protected final Map<Rule, BiConsumer<RuleContext, BendableBigDecimalScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, BendableBigDecimalScore>>();
    private BigDecimal[] hardScores;
    private BigDecimal[] softScores;

    public BendableBigDecimalScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled, BendableBigDecimalScore.zero(hardLevelsSize, softLevelsSize));
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public BigDecimal getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public BigDecimal getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Override
    public void configureConstraintWeight(Rule rule, BendableBigDecimalScore constraintWeight) {
        BiConsumer<RuleContext, BigDecimal> matchExecutor;
        super.configureConstraintWeight(rule, constraintWeight);
        if (constraintWeight.equals(BendableBigDecimalScore.zero(this.hardScores.length, this.softScores.length))) {
            matchExecutor = (kcontext, matchWeight) -> {};
        } else {
            Integer singleLevel = null;
            BigDecimal singleLevelWeight = null;
            for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
                BigDecimal levelWeight = constraintWeight.getHardOrSoftScore(i);
                if (levelWeight.equals(BigDecimal.ZERO)) continue;
                if (singleLevel != null) {
                    singleLevel = null;
                    singleLevelWeight = null;
                    break;
                }
                singleLevel = i;
                singleLevelWeight = levelWeight;
            }
            if (singleLevel != null) {
                BigDecimal levelWeight = singleLevelWeight;
                if (singleLevel < constraintWeight.getHardLevelsSize()) {
                    int level = singleLevel;
                    matchExecutor = (kcontext, matchWeight) -> this.addHardConstraintMatch((RuleContext)kcontext, level, levelWeight.multiply((BigDecimal)matchWeight));
                } else {
                    int level = singleLevel - constraintWeight.getHardLevelsSize();
                    matchExecutor = (kcontext, matchWeight) -> this.addSoftConstraintMatch((RuleContext)kcontext, level, levelWeight.multiply((BigDecimal)matchWeight));
                }
            } else {
                matchExecutor = (kcontext, matchWeight) -> {
                    int i;
                    BigDecimal[] hardWeights = new BigDecimal[this.hardScores.length];
                    BigDecimal[] softWeights = new BigDecimal[this.softScores.length];
                    for (i = 0; i < hardWeights.length; ++i) {
                        hardWeights[i] = constraintWeight.getHardScore(i).multiply((BigDecimal)matchWeight);
                    }
                    for (i = 0; i < softWeights.length; ++i) {
                        softWeights[i] = constraintWeight.getSoftScore(i).multiply((BigDecimal)matchWeight);
                    }
                    this.addMultiConstraintMatch((RuleContext)kcontext, hardWeights, softWeights);
                };
            }
        }
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> {
            int i;
            BigDecimal[] hardWeights = new BigDecimal[this.hardScores.length];
            BigDecimal[] softWeights = new BigDecimal[this.softScores.length];
            for (i = 0; i < hardWeights.length; ++i) {
                hardWeights[i] = constraintWeight.getHardScore(i).multiply(weightMultiplier.getHardScore(i));
            }
            for (i = 0; i < softWeights.length; ++i) {
                softWeights[i] = constraintWeight.getSoftScore(i).multiply(weightMultiplier.getSoftScore(i));
            }
            this.addMultiConstraintMatch((RuleContext)kcontext, hardWeights, softWeights);
        });
    }

    public void penalize(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.reward(kcontext, weightMultiplier.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal[] hardWeightsMultiplier, BigDecimal[] softWeightsMultiplier) {
        int i;
        BigDecimal[] negatedHardWeightsMultiplier = new BigDecimal[this.hardScores.length];
        BigDecimal[] negatedSoftWeightsMultiplier = new BigDecimal[this.softScores.length];
        for (i = 0; i < negatedHardWeightsMultiplier.length; ++i) {
            negatedHardWeightsMultiplier[i] = hardWeightsMultiplier[i].negate();
        }
        for (i = 0; i < negatedSoftWeightsMultiplier.length; ++i) {
            negatedSoftWeightsMultiplier[i] = softWeightsMultiplier[i].negate();
        }
        this.reward(kcontext, negatedHardWeightsMultiplier, negatedSoftWeightsMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE);
    }

    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, BigDecimal> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, BigDecimal[] hardWeightsMultiplier, BigDecimal[] softWeightsMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, BendableBigDecimalScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, BendableBigDecimalScore.of(hardWeightsMultiplier, softWeightsMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, BigDecimal weight) {
        this.hardScores[hardLevel] = this.hardScores[hardLevel].add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScores[hardLevel] = this.hardScores[hardLevel].subtract(weight);
        }, () -> {
            Object[] newHardScores = new BigDecimal[this.hardScores.length];
            Arrays.fill(newHardScores, BigDecimal.ZERO);
            Object[] newSoftScores = new BigDecimal[this.softScores.length];
            Arrays.fill(newSoftScores, BigDecimal.ZERO);
            newHardScores[hardLevel] = weight;
            return BendableBigDecimalScore.of((BigDecimal[])newHardScores, (BigDecimal[])newSoftScores);
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, BigDecimal weight) {
        this.softScores[softLevel] = this.softScores[softLevel].add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScores[softLevel] = this.softScores[softLevel].subtract(weight);
        }, () -> {
            Object[] newHardScores = new BigDecimal[this.hardScores.length];
            Arrays.fill(newHardScores, BigDecimal.ZERO);
            Object[] newSoftScores = new BigDecimal[this.softScores.length];
            Arrays.fill(newSoftScores, BigDecimal.ZERO);
            newSoftScores[softLevel] = weight;
            return BendableBigDecimalScore.of((BigDecimal[])newHardScores, (BigDecimal[])newSoftScores);
        });
    }

    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal[] hardWeights, BigDecimal[] softWeights) {
        int i;
        if (this.hardScores.length != hardWeights.length) {
            throw new IllegalArgumentException("The hardScores length (" + this.hardScores.length + ") is different than the hardWeights length (" + hardWeights.length + ").");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            this.hardScores[i] = this.hardScores[i].add(hardWeights[i]);
        }
        if (this.softScores.length != softWeights.length) {
            throw new IllegalArgumentException("The softScores length (" + this.softScores.length + ") is different than the softWeights length (" + softWeights.length + ").");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            this.softScores[i] = this.softScores[i].add(softWeights[i]);
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                this.hardScores[i] = this.hardScores[i].subtract(hardWeights[i]);
            }
            for (i = 0; i < this.softScores.length; ++i) {
                this.softScores[i] = this.softScores[i].subtract(softWeights[i]);
            }
        }, () -> BendableBigDecimalScore.of(hardWeights, softWeights));
    }

    @Override
    public BendableBigDecimalScore extractScore(int initScore) {
        return new BendableBigDecimalScore(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

