/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.IterableSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class ChangeMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector entitySelector;
    protected final ValueSelector valueSelector;
    protected final boolean randomSelection;
    protected final boolean chained;
    protected SingletonInverseVariableSupply inverseVariableSupply = null;

    public ChangeMoveSelector(EntitySelector entitySelector, ValueSelector valueSelector, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
        this.chained = variableDescriptor.isChained();
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean supportsPhaseAndSolverCaching() {
        return !this.chained;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        if (this.chained) {
            SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
            this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(this.valueSelector.getVariableDescriptor()));
        }
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        if (this.chained) {
            this.inverseVariableSupply = null;
        }
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (this.valueSelector instanceof IterableSelector) {
            return this.entitySelector.getSize() * ((IterableSelector)((Object)this.valueSelector)).getSize();
        }
        long size = 0L;
        Iterator<Object> it = this.entitySelector.endingIterator();
        while (it.hasNext()) {
            Object entity = it.next();
            size += this.valueSelector.getSize(entity);
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        final GenuineVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        if (!this.randomSelection) {
            if (this.chained) {
                return new AbstractOriginalChangeIterator<Move>(this.entitySelector, this.valueSelector){

                    @Override
                    protected Move newChangeSelection(Object entity, Object toValue) {
                        return new ChainedChangeMove(entity, variableDescriptor, ChangeMoveSelector.this.inverseVariableSupply, toValue);
                    }
                };
            }
            return new AbstractOriginalChangeIterator<Move>(this.entitySelector, this.valueSelector){

                @Override
                protected Move newChangeSelection(Object entity, Object toValue) {
                    return new ChangeMove(entity, variableDescriptor, toValue);
                }
            };
        }
        if (this.chained) {
            return new AbstractRandomChangeIterator<Move>(this.entitySelector, this.valueSelector){

                @Override
                protected Move newChangeSelection(Object entity, Object toValue) {
                    return new ChainedChangeMove(entity, variableDescriptor, ChangeMoveSelector.this.inverseVariableSupply, toValue);
                }
            };
        }
        return new AbstractRandomChangeIterator<Move>(this.entitySelector, this.valueSelector){

            @Override
            protected Move newChangeSelection(Object entity, Object toValue) {
                return new ChangeMove(entity, variableDescriptor, toValue);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }
}

