/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public class ChildThreadPlumbingTermination
extends AbstractTermination {
    protected boolean terminateChildren = false;

    public synchronized boolean terminateChildren() {
        boolean terminationEarlySuccessful = !this.terminateChildren;
        this.terminateChildren = true;
        return terminationEarlySuccessful;
    }

    @Override
    public synchronized boolean isSolverTerminated(DefaultSolverScope solverScope) {
        if (Thread.currentThread().isInterrupted()) {
            this.logger.info("A child solver thread got interrupted, so these child solvers are terminating early.");
            this.terminateChildren = true;
        }
        return this.terminateChildren;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        throw new IllegalStateException(ChildThreadPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return -1.0;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        throw new IllegalStateException(ChildThreadPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public Termination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        return this;
    }

    public String toString() {
        return "ChildThreadPlumbing()";
    }
}

