/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.definition;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public interface ScoreDefinition<S extends Score> {
    public String getInitLabel();

    public int getLevelsSize();

    public String[] getLevelLabels();

    public Class<S> getScoreClass();

    public S getZeroScore();

    default public boolean isPositiveOrZero(S score) {
        return score.compareTo(this.getZeroScore()) >= 0;
    }

    default public boolean isNegativeOrZero(S score) {
        return score.compareTo(this.getZeroScore()) <= 0;
    }

    public String formatScore(S var1);

    public S parseScore(String var1);

    public S fromLevelNumbers(int var1, Number[] var2);

    public ScoreHolder buildScoreHolder(boolean var1);

    public S buildOptimisticBound(InitializingScoreTrend var1, S var2);

    public S buildPessimisticBound(InitializingScoreTrend var1, S var2);
}

