/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.DefaultBiConstraintCollector;
import org.optaplanner.core.impl.score.stream.uni.DefaultUniConstraintCollector;

public final class ConstraintCollectors {
    public static <A> UniConstraintCollector<A, ?, Integer> count() {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countLong() {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> countBi() {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> countLongBi() {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Integer> countDistinct(Function<A, ?> groupValueMapping) {
        class CountDistinctResultContainer {
            int count = 0;
            Map<Object, int[]> objectCountMap = new HashMap<Object, int[]>();

            CountDistinctResultContainer() {
            }
        }
        return new DefaultUniConstraintCollector<Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            int[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new int[1]);
            if (objectCount[0] == 0) {
                ++resultContainer.count;
            }
            objectCount[0] = objectCount[0] + 1;
            return () -> {
                int[] objectCount2 = resultContainer.objectCountMap.get(value);
                if (objectCount2 == null) {
                    throw new IllegalStateException("Impossible state: the value (" + value + ") of A (" + a + ") is removed more times than it was added.");
                }
                objectCount2[0] = objectCount2[0] - 1;
                if (objectCount2[0] == 0) {
                    resultContainer.objectCountMap.remove(value);
                    --resultContainer.count;
                }
            };
        }, resultContainer -> resultContainer.count);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countDistinctLong(Function<A, ?> groupValueMapping) {
        class CountDistinctResultContainer {
            long count = 0L;
            Map<Object, long[]> objectCountMap = new HashMap<Object, long[]>();

            CountDistinctResultContainer() {
            }
        }
        return new DefaultUniConstraintCollector<Object, CountDistinctResultContainer, Long>(() -> new CountDistinctResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            long[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new long[1]);
            if (objectCount[0] == 0L) {
                ++resultContainer.count;
            }
            objectCount[0] = objectCount[0] + 1L;
            return () -> {
                long[] objectCount2 = resultContainer.objectCountMap.get(value);
                if (objectCount2 == null) {
                    throw new IllegalStateException("Impossible state: the value (" + value + ") of A (" + a + ") is removed more times than it was added.");
                }
                objectCount2[0] = objectCount2[0] - 1L;
                if (objectCount2[0] == 0L) {
                    resultContainer.objectCountMap.remove(value);
                    --resultContainer.count;
                }
            };
        }, resultContainer -> resultContainer.count);
    }

    public static <A> UniConstraintCollector<A, ?, Integer> sum(ToIntFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            int value = groupValueMapping.applyAsInt((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> sumLong(ToLongFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            long value = groupValueMapping.applyAsLong((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> sum(ToIntBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            int value = groupValueMapping.applyAsInt((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> sumLong(ToLongBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            long value = groupValueMapping.applyAsLong((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    private ConstraintCollectors() {
    }
}

