/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move.generic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.pillar.PillarSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.AbstractPillarMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.PillarChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

@XStreamAlias(value="pillarChangeMoveSelector")
public class PillarChangeMoveSelectorConfig
extends AbstractPillarMoveSelectorConfig<PillarChangeMoveSelectorConfig> {
    @XStreamAlias(value="valueSelector")
    private ValueSelectorConfig valueSelectorConfig = null;

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        PillarSelectorConfig pillarSelectorConfig_ = (PillarSelectorConfig)ObjectUtils.defaultIfNull((Object)this.pillarSelectorConfig, (Object)new PillarSelectorConfig());
        List<String> variableNameIncludeList = this.valueSelectorConfig == null ? null : (this.valueSelectorConfig.getVariableName() == null ? null : Collections.singletonList(this.valueSelectorConfig.getVariableName()));
        PillarSelector pillarSelector = pillarSelectorConfig_.buildPillarSelector(configPolicy, this.subPillarType, this.subPillarSequenceComparatorClass, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection), variableNameIncludeList);
        ValueSelectorConfig valueSelectorConfig_ = (ValueSelectorConfig)ObjectUtils.defaultIfNull((Object)this.valueSelectorConfig, (Object)new ValueSelectorConfig());
        ValueSelector valueSelector = valueSelectorConfig_.buildValueSelector(configPolicy, pillarSelector.getEntityDescriptor(), minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        return new PillarChangeMoveSelector(pillarSelector, valueSelector, randomSelection);
    }

    @Override
    public void inherit(PillarChangeMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.valueSelectorConfig = ConfigUtils.inheritConfig(this.valueSelectorConfig, inheritedConfig.getValueSelectorConfig());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pillarSelectorConfig + ", " + this.valueSelectorConfig + ")";
    }
}

