/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;

public final class BavetGroupBiNode<GroupKey_, ResultContainer_, Result_>
extends BavetAbstractBiNode<GroupKey_, Result_> {
    private final Function<ResultContainer_, Result_> finisher;
    private final List<BavetAbstractBiNode<GroupKey_, Result_>> childNodeList = new ArrayList<BavetAbstractBiNode<GroupKey_, Result_>>();

    public BavetGroupBiNode(BavetConstraintSession session, int nodeOrder, Function<ResultContainer_, Result_> finisher) {
        super(session, nodeOrder);
        this.finisher = finisher;
    }

    @Override
    public void addChildNode(BavetAbstractBiNode<GroupKey_, Result_> childNode) {
        this.childNodeList.add(childNode);
    }

    public BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_> createTuple(BavetAbstractBiTuple<GroupKey_, Result_> parentTuple) {
        throw new IllegalStateException("The Grouped node (" + this.getClass().getSimpleName() + ") can't have a parentTuple (" + parentTuple + ");");
    }

    public BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_> createTuple(GroupKey_ groupKey, ResultContainer_ resultContainer) {
        return new BavetGroupBiTuple(this, groupKey, resultContainer);
    }

    public void refresh(BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_> tuple) {
        List<BavetAbstractBiTuple<GroupKey_, Result_>> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractBiTuple<GroupKey_, Result_> bavetAbstractBiTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractBiTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive()) {
            tuple.updateResult(this.finisher);
            for (BavetAbstractBiNode bavetAbstractBiNode : this.childNodeList) {
                BavetAbstractBiTuple childTuple = bavetAbstractBiNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
        tuple.refreshed();
    }

    public String toString() {
        return "Group() with " + this.childNodeList.size() + " children";
    }
}

