/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.io.Serializable;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintJustificationComparator;

public final class ConstraintMatch
implements Serializable,
Comparable<ConstraintMatch> {
    private final String constraintPackage;
    private final String constraintName;
    private final List<Object> justificationList;
    private final Score score;

    public ConstraintMatch(String constraintPackage, String constraintName, List<Object> justificationList, Score score) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.justificationList = justificationList;
        this.score = score;
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public List<Object> getJustificationList() {
        return this.justificationList;
    }

    public Score getScore() {
        return this.score;
    }

    public String getConstraintId() {
        return this.constraintPackage + "/" + this.constraintName;
    }

    public String getIdentificationString() {
        return this.getConstraintId() + "/" + this.justificationList;
    }

    @Override
    public int compareTo(ConstraintMatch other) {
        if (!this.constraintPackage.equals(other.constraintPackage)) {
            return this.constraintPackage.compareTo(other.constraintPackage);
        }
        if (!this.constraintName.equals(other.constraintName)) {
            return this.constraintName.compareTo(other.constraintName);
        }
        ConstraintJustificationComparator comparator = new ConstraintJustificationComparator();
        for (int i = 0; i < this.justificationList.size() && i < other.justificationList.size(); ++i) {
            Object right;
            Object left = this.justificationList.get(i);
            int comparison = comparator.compare(left, right = other.justificationList.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        if (this.justificationList.size() != other.justificationList.size()) {
            return this.justificationList.size() < other.justificationList.size() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ConstraintMatch) {
            ConstraintMatch other = (ConstraintMatch)o;
            return this.constraintPackage.equals(other.constraintPackage) && this.constraintName.equals(other.constraintName) && this.justificationList.equals(other.justificationList);
        }
        return false;
    }

    public int hashCode() {
        return ((629 + this.constraintPackage.hashCode()) * 37 + this.constraintName.hashCode()) * 37 + this.justificationList.hashCode();
    }

    public String toString() {
        return this.getIdentificationString() + "=" + this.score;
    }
}

