/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.tri;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetFilterTriConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetScoringTriConstraintStream;
import org.optaplanner.core.impl.score.stream.tri.InnerTriConstraintStream;

public abstract class BavetAbstractTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractConstraintStream<Solution_>
implements InnerTriConstraintStream<A, B, C> {
    protected final List<BavetAbstractTriConstraintStream<Solution_, A, B, C>> childStreamList = new ArrayList<BavetAbstractTriConstraintStream<Solution_, A, B, C>>(2);

    public BavetAbstractTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory) {
        super(constraintFactory);
    }

    protected void addChildStream(BavetAbstractTriConstraintStream<Solution_, A, B, C> childStream) {
        this.childStreamList.add(childStream);
    }

    public BavetAbstractTriConstraintStream<Solution_, A, B, C> filter(TriPredicate<A, B, C> predicate) {
        BavetFilterTriConstraintStream stream = new BavetFilterTriConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntTriFunction<A, B, C> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongTriFunction<A, B, C> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, TriFunction<A, B, C, BigDecimal> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringTriConstraintStream stream = new BavetScoringTriConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    public BavetAbstractTriNode<A, B, C> createNodeChain(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractTriNode<A, B, C> parentNode) {
        BavetAbstractTriNode<A, B, C> node = this.createNode(buildPolicy, constraintWeight, nodeOrder, parentNode);
        node = this.processNode(buildPolicy, nodeOrder, parentNode, node);
        this.createChildNodeChains(buildPolicy, constraintWeight, nodeOrder, node);
        return node;
    }

    protected BavetAbstractTriNode<A, B, C> processNode(BavetNodeBuildPolicy<Solution_> buildPolicy, int nodeOrder, BavetAbstractTriNode<A, B, C> parentNode, BavetAbstractTriNode<A, B, C> node) {
        buildPolicy.updateNodeOrderMaximum(nodeOrder);
        BavetAbstractTriNode<A, B, C> sharedNode = buildPolicy.retrieveSharedNode(node);
        if (sharedNode != node) {
            node = sharedNode;
        } else if (parentNode != null) {
            parentNode.addChildNode(node);
        }
        return node;
    }

    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractTriNode<A, B, C> node) {
        if (this.childStreamList.isEmpty()) {
            throw new IllegalStateException("The stream (" + this + ") leads to nowhere.\nMaybe don't create it.");
        }
        for (BavetAbstractTriConstraintStream<Solution_, A, B, C> childStream : this.childStreamList) {
            childStream.createNodeChain(buildPolicy, constraintWeight, nodeOrder + 1, node);
        }
    }

    protected abstract BavetAbstractTriNode<A, B, C> createNode(BavetNodeBuildPolicy<Solution_> var1, Score<?> var2, int var3, BavetAbstractTriNode<A, B, C> var4);
}

