/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetScoringNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetScoringUniTuple;

public final class BavetScoringUniNode<A>
extends BavetAbstractUniNode<A>
implements BavetScoringNode {
    private final BavetAbstractUniNode<A> parentNode;
    private final String constraintPackage;
    private final String constraintName;
    private final Score<?> constraintWeight;
    private final BiFunction<A, Consumer<Score<?>>, UndoScoreImpacter> scoreImpacter;
    private final boolean constraintMatchEnabled;
    private final Set<BavetScoringUniTuple<A>> tupleSet;

    public BavetScoringUniNode(BavetConstraintSession session, int nodeOrder, BavetAbstractUniNode<A> parentNode, String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, Consumer<Score<?>>, UndoScoreImpacter> scoreImpacter) {
        super(session, nodeOrder);
        this.parentNode = parentNode;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
        this.constraintMatchEnabled = session.isConstraintMatchEnabled();
        this.tupleSet = this.constraintMatchEnabled ? new HashSet() : null;
    }

    @Override
    public BavetScoringUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetScoringUniTuple<A>(this, parentTuple);
    }

    public void refresh(BavetScoringUniTuple<A> tuple) {
        A a = tuple.getFactA();
        UndoScoreImpacter oldUndoScoreImpacter = tuple.getUndoScoreImpacter();
        if (oldUndoScoreImpacter != null) {
            oldUndoScoreImpacter.undoScoreImpact();
            if (this.constraintMatchEnabled) {
                tuple.setMatchScore(null);
                boolean removed = this.tupleSet.remove(tuple);
                if (!removed) {
                    throw new IllegalStateException("Impossible state: The node with constraintId (" + this.getConstraintId() + ") could not remove the tuple (" + tuple + ") from the tupleSet.");
                }
            }
        }
        if (tuple.isActive()) {
            boolean added;
            UndoScoreImpacter undoScoreImpacter = this.scoreImpacter.apply(a, tuple::setMatchScore);
            tuple.setUndoScoreImpacter(undoScoreImpacter);
            if (this.constraintMatchEnabled && !(added = this.tupleSet.add(tuple))) {
                throw new IllegalStateException("Impossible state: The node with constraintId (" + this.getConstraintId() + ") could not add the tuple (" + tuple + ") to the tupleSet.");
            }
        } else {
            tuple.setUndoScoreImpacter(null);
        }
        tuple.refreshed();
    }

    @Override
    public ConstraintMatchTotal buildConstraintMatchTotal(Score<?> zeroScore) {
        ConstraintMatchTotal constraintMatchTotal = new ConstraintMatchTotal(this.constraintPackage, this.constraintName, this.constraintWeight, zeroScore);
        for (BavetScoringUniTuple<A> tuple : this.tupleSet) {
            constraintMatchTotal.addConstraintMatch(Collections.singletonList(tuple.getFactA()), tuple.getMatchScore());
        }
        return constraintMatchTotal;
    }

    public String toString() {
        return "Scoring(" + this.constraintWeight + ")";
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public String getConstraintId() {
        return ConstraintMatchTotal.composeConstraintId(this.constraintPackage, this.constraintName);
    }

    @Override
    public Score<?> getConstraintWeight() {
        return this.constraintWeight;
    }
}

