/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block4;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsInferredMetadata;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsLogicalTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsMetadata;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;

public final class DroolsBiCondition<A, B> {
    private final DroolsMetadata<Object, A> aMetadata;
    private final DroolsMetadata<Object, B> bMetadata;

    public DroolsBiCondition(DroolsMetadata<Object, A> aMetadata, DroolsMetadata<Object, B> bMetadata) {
        this.aMetadata = aMetadata;
        this.bMetadata = bMetadata;
    }

    public DroolsBiCondition(Declaration<DroolsLogicalTuple> aVariableDeclaration, Function<Declaration<DroolsLogicalTuple>, PatternDSL.PatternDef<DroolsLogicalTuple>> patternProvider) {
        PatternDSL.PatternDef<DroolsLogicalTuple> pattern = patternProvider.apply(aVariableDeclaration);
        this.aMetadata = DroolsMetadata.ofInferred(aVariableDeclaration, () -> pattern, 0);
        this.bMetadata = DroolsMetadata.ofInferred(aVariableDeclaration, () -> pattern, 1);
    }

    public DroolsMetadata<Object, A> getAMetadata() {
        return this.aMetadata;
    }

    public DroolsMetadata<Object, B> getBMetadata() {
        return this.bMetadata;
    }

    public DroolsBiCondition<A, B> andFilter(BiPredicate<A, B> predicate) {
        Predicate2 & Serializable filter = (Predicate2 & Serializable)(b, a) -> predicate.test(this.aMetadata.extract(a), this.bMetadata.extract(b));
        Supplier patternSupplier = () -> this.bMetadata.buildPattern().expr("Filter using " + predicate, this.aMetadata.getVariableDeclaration(), filter);
        return new DroolsBiCondition<A, B>(this.aMetadata, this.bMetadata.substitute(patternSupplier));
    }

    public <C> DroolsTriCondition<A, B, C> andJoin(DroolsUniCondition<C> cCondition, AbstractTriJoiner<A, B, C> triJoiner) {
        DroolsMetadata cMetadata = cCondition.getAMetadata();
        Supplier newPattern = () -> cMetadata.buildPattern().expr("Filter using " + triJoiner, this.aMetadata.getVariableDeclaration(), this.bMetadata.getVariableDeclaration(), (Predicate3 & Serializable)(c, a, b) -> DroolsBiCondition.matches(triJoiner, this.aMetadata.extract(a), this.bMetadata.extract(b), cMetadata.extract(c)));
        return new DroolsTriCondition<A, B, C>(this.aMetadata, this.bMetadata, cMetadata.substitute(newPattern));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, __, ___) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext);
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntBiFunction<A, B> matchWeighter) {
        ToIntBiFunction<Object, Object> weightMultiplier = (a, b) -> matchWeighter.applyAsInt(this.aMetadata.extract(a), this.bMetadata.extract(b));
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, a, b) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, weightMultiplier.applyAsInt(a, b));
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongBiFunction<A, B> matchWeighter) {
        ToLongBiFunction<Object, Object> weightMultiplier = (a, b) -> matchWeighter.applyAsLong(this.aMetadata.extract(a), this.bMetadata.extract(b));
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, a, b) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, weightMultiplier.applyAsLong(a, b));
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, BiFunction<A, B, BigDecimal> matchWeighter) {
        BiFunction<Object, Object, BigDecimal> weightMultiplier = (a, b) -> (BigDecimal)matchWeighter.apply(this.aMetadata.extract(a), this.bMetadata.extract(b));
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, a, b) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, (BigDecimal)weightMultiplier.apply(a, b));
        });
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block4<Drools, ScoreHolder, Object, Object> consequenceImpl) {
        ConsequenceBuilder._3 consequence = DSL.on(scoreHolderGlobal, this.aMetadata.getVariableDeclaration(), this.bMetadata.getVariableDeclaration()).execute(consequenceImpl);
        if (this.aMetadata instanceof DroolsInferredMetadata && this.bMetadata instanceof DroolsInferredMetadata) {
            return Arrays.asList(this.bMetadata.buildPattern(), consequence);
        }
        return Arrays.asList(this.aMetadata.buildPattern(), this.bMetadata.buildPattern(), consequence);
    }

    private static <A, B, C> boolean matches(AbstractTriJoiner<A, B, C> triJoiner, A a, B b, C c) {
        JoinerType[] joinerTypes = triJoiner.getJoinerTypes();
        for (int i = 0; i < joinerTypes.length; ++i) {
            Object rightMapping;
            JoinerType joinerType = joinerTypes[i];
            Object leftMapping = triJoiner.getLeftMapping(i).apply(a, b);
            if (joinerType.matches(leftMapping, rightMapping = triJoiner.getRightMapping(i).apply(c))) continue;
            return false;
        }
        return true;
    }
}

