/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Arrays;
import java.util.Objects;

public final class DroolsLogicalTuple {
    private static final int MAXIMUM_SUPPORTED_CARDINALITY = 3;
    private final Object ruleId;
    private final Object[] items;

    public DroolsLogicalTuple(Object ruleId, Object ... items) {
        Objects.requireNonNull(ruleId, "Logical tuple rule context must not be null.");
        this.ruleId = ruleId;
        int itemCount = items.length;
        if (itemCount == 0) {
            throw new IllegalArgumentException("Logical tuple must have at least one element.");
        }
        if (itemCount > 3) {
            throw new IllegalArgumentException("Logical tuple must have at most 3 elements, has " + itemCount + ".");
        }
        this.items = new Object[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            Object item = items[i];
            Objects.requireNonNull(item, "Logical tuple does not accept null arguments.");
            this.items[i] = item;
        }
    }

    public int getCardinality() {
        return this.items.length;
    }

    public Object getRuleId() {
        return this.ruleId;
    }

    public <T> T getItem(int index) {
        return (T)this.items[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Objects.equals(this.getClass(), o.getClass())) {
            return false;
        }
        DroolsLogicalTuple that = (DroolsLogicalTuple)o;
        return Objects.equals(this.ruleId, that.ruleId) && Arrays.equals(this.items, that.items);
    }

    public int hashCode() {
        int result = Objects.hash(this.ruleId);
        result = 31 * result + Arrays.hashCode(this.items);
        return result;
    }

    public String toString() {
        return "DroolsLogicalTuple{ruleId='" + this.ruleId + '\'' + ", items=" + Arrays.toString(this.items) + '}';
    }
}

