/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.drools.model.Declaration;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate1;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsLogicalTuple;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;

public final class DroolsGroupingUniConstraintStream<Solution_, A, NewA>
extends DroolsAbstractUniConstraintStream<Solution_, NewA> {
    private final DroolsAbstractUniConstraintStream<Solution_, A> parent;
    private final Function<A, NewA> groupKeyMapping;
    private final UniConstraintCollector<A, ?, NewA> collector;
    private int ruleId = -1;

    public DroolsGroupingUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, Function<A, NewA> groupKeyMapping) {
        super(constraintFactory);
        this.parent = parent;
        this.groupKeyMapping = groupKeyMapping;
        this.collector = null;
    }

    public <ResultContainer_> DroolsGroupingUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, UniConstraintCollector<A, ResultContainer_, NewA> collector) {
        super(constraintFactory);
        this.parent = parent;
        this.groupKeyMapping = null;
        this.collector = collector;
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    @Override
    public Optional<Rule> buildRule(DroolsConstraint<Solution_> constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        Rule rule;
        Integer createdRuleId = this.createRuleIdIfAbsent((DroolsConstraintFactory<Solution_>)constraint.getConstraintFactory());
        if (this.groupKeyMapping != null) {
            String ruleName = "Helper rule #" + createdRuleId + " (GroupBy collecting)";
            rule = PatternDSL.rule((String)constraint.getConstraintPackage(), (String)ruleName).build(this.parent.createCondition().completeWithLogicalInsert((Object)createdRuleId, this.groupKeyMapping).toArray(new RuleItemBuilder[0]));
        } else if (this.collector != null) {
            String ruleName = "Helper rule #" + createdRuleId + " (GroupBy remapping)";
            rule = PatternDSL.rule((String)constraint.getConstraintPackage(), (String)ruleName).build(this.parent.createCondition().completeWithLogicalInsert((Object)createdRuleId, this.collector).toArray(new RuleItemBuilder[0]));
        } else {
            throw new IllegalStateException();
        }
        return Optional.of(rule);
    }

    @Override
    public DroolsUniCondition<NewA> createCondition() {
        return new DroolsUniCondition((Declaration<DroolsLogicalTuple>)PatternDSL.declarationOf(DroolsLogicalTuple.class), var -> {
            Integer createdRuleId = this.createRuleIdIfAbsent((DroolsConstraintFactory<Solution_>)this.getConstraintFactory());
            return PatternDSL.pattern((Variable)var).expr((Predicate1 & Serializable)logicalTuple -> Objects.equals(logicalTuple.getRuleId(), createdRuleId));
        });
    }

    private int createRuleIdIfAbsent(DroolsConstraintFactory<Solution_> constraintFactory) {
        if (this.ruleId < 0) {
            this.ruleId = constraintFactory.getNextRuleId();
        }
        return this.ruleId;
    }

    public String toString() {
        return "GroupBy()";
    }
}

