/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.DefaultBiConstraintCollector;
import org.optaplanner.core.impl.score.stream.uni.DefaultUniConstraintCollector;

public final class ConstraintCollectors {
    public static <A> UniConstraintCollector<A, ?, Integer> count() {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countLong() {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> countBi() {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> countLongBi() {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Integer> countDistinct(Function<A, ?> groupValueMapping) {
        class CountDistinctResultContainer {
            int count = 0;
            Map<Object, int[]> objectCountMap = new HashMap<Object, int[]>();

            CountDistinctResultContainer() {
            }
        }
        return new DefaultUniConstraintCollector<Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            int[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new int[1]);
            if (objectCount[0] == 0) {
                ++resultContainer.count;
            }
            objectCount[0] = objectCount[0] + 1;
            return () -> {
                int[] objectCount2 = resultContainer.objectCountMap.get(value);
                if (objectCount2 == null) {
                    throw new IllegalStateException("Impossible state: the value (" + value + ") of A (" + a + ") is removed more times than it was added.");
                }
                objectCount2[0] = objectCount2[0] - 1;
                if (objectCount2[0] == 0) {
                    resultContainer.objectCountMap.remove(value);
                    --resultContainer.count;
                }
            };
        }, resultContainer -> resultContainer.count);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countDistinctLong(Function<A, ?> groupValueMapping) {
        class CountDistinctResultContainer {
            long count = 0L;
            Map<Object, long[]> objectCountMap = new HashMap<Object, long[]>();

            CountDistinctResultContainer() {
            }
        }
        return new DefaultUniConstraintCollector<Object, CountDistinctResultContainer, Long>(() -> new CountDistinctResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            long[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new long[1]);
            if (objectCount[0] == 0L) {
                ++resultContainer.count;
            }
            objectCount[0] = objectCount[0] + 1L;
            return () -> {
                long[] objectCount2 = resultContainer.objectCountMap.get(value);
                if (objectCount2 == null) {
                    throw new IllegalStateException("Impossible state: the value (" + value + ") of A (" + a + ") is removed more times than it was added.");
                }
                objectCount2[0] = objectCount2[0] - 1L;
                if (objectCount2[0] == 0L) {
                    resultContainer.objectCountMap.remove(value);
                    --resultContainer.count;
                }
            };
        }, resultContainer -> resultContainer.count);
    }

    public static <A> UniConstraintCollector<A, ?, Integer> sum(ToIntFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            int value = groupValueMapping.applyAsInt((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> sumLong(ToLongFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            long value = groupValueMapping.applyAsLong((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, BigDecimal> sumBigDecimal(Function<? super A, BigDecimal> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{BigDecimal.ZERO}, (resultContainer, a) -> {
            BigDecimal value = (BigDecimal)groupValueMapping.apply((Object)a);
            resultContainer[0] = resultContainer[0].add(value);
            return () -> {
                resultContainer[0] = resultContainer[0].subtract(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, BigInteger> sumBigInteger(Function<? super A, BigInteger> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, BigInteger[], BigInteger>(() -> new BigInteger[]{BigInteger.ZERO}, (resultContainer, a) -> {
            BigInteger value = (BigInteger)groupValueMapping.apply((Object)a);
            resultContainer[0] = resultContainer[0].add(value);
            return () -> {
                resultContainer[0] = resultContainer[0].subtract(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Duration> sumDuration(Function<? super A, Duration> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, Duration[], Duration>(() -> new Duration[]{Duration.ZERO}, (resultContainer, a) -> {
            Duration value = (Duration)groupValueMapping.apply((Object)a);
            resultContainer[0] = resultContainer[0].plus(value);
            return () -> {
                resultContainer[0] = resultContainer[0].minus(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Period> sumPeriod(Function<? super A, Period> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, Period[], Period>(() -> new Period[]{Period.ZERO}, (resultContainer, a) -> {
            Period value = (Period)groupValueMapping.apply((Object)a);
            resultContainer[0] = resultContainer[0].plus(value);
            return () -> {
                resultContainer[0] = resultContainer[0].minus(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> sum(ToIntBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            int value = groupValueMapping.applyAsInt((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> sumLong(ToLongBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            long value = groupValueMapping.applyAsLong((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigDecimal> sumBigDecimal(BiFunction<? super A, ? super B, BigDecimal> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{BigDecimal.ZERO}, (resultContainer, a, b) -> {
            BigDecimal value = (BigDecimal)groupValueMapping.apply((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0].add(value);
            return () -> {
                resultContainer[0] = resultContainer[0].subtract(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigInteger> sumBigInteger(BiFunction<? super A, ? super B, BigInteger> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, BigInteger[], BigInteger>(() -> new BigInteger[]{BigInteger.ZERO}, (resultContainer, a, b) -> {
            BigInteger value = (BigInteger)groupValueMapping.apply((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0].add(value);
            return () -> {
                resultContainer[0] = resultContainer[0].subtract(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Duration> sumDuration(BiFunction<? super A, ? super B, Duration> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, Duration[], Duration>(() -> new Duration[]{Duration.ZERO}, (resultContainer, a, b) -> {
            Duration value = (Duration)groupValueMapping.apply((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0].plus(value);
            return () -> {
                resultContainer[0] = resultContainer[0].minus(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Period> sumPeriod(BiFunction<? super A, ? super B, Period> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, Period[], Period>(() -> new Period[]{Period.ZERO}, (resultContainer, a, b) -> {
            Period value = (Period)groupValueMapping.apply((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0].plus(value);
            return () -> {
                resultContainer[0] = resultContainer[0].minus(value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, A> min(Comparator<A> comparator) {
        return ConstraintCollectors.minOrMax(comparator, true);
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, A> min() {
        return ConstraintCollectors.min(Comparable::compareTo);
    }

    public static <A> UniConstraintCollector<A, ?, A> max(Comparator<A> comparator) {
        return ConstraintCollectors.minOrMax(comparator, false);
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, A> max() {
        return ConstraintCollectors.max(Comparable::compareTo);
    }

    private static <A> UniConstraintCollector<A, SortedMap<A, Long>, A> minOrMax(Comparator<A> comparator, boolean min) {
        Function<SortedMap, Object> keySupplier = min ? SortedMap::firstKey : SortedMap::lastKey;
        return new DefaultUniConstraintCollector<Object, SortedMap, Object>(() -> new TreeMap(comparator), (resultContainer, a) -> {
            resultContainer.compute(a, (key, value) -> value == null ? 1L : value + 1L);
            return () -> resultContainer.compute(a, (key, value) -> value == 1L ? null : Long.valueOf(value - 1L));
        }, resultContainer -> resultContainer.size() == 0 ? null : keySupplier.apply((SortedMap)resultContainer));
    }

    private ConstraintCollectors() {
    }
}

