/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniNode;

public final class BavetConstraint<Solution_>
implements Constraint {
    private final BavetConstraintFactory<Solution_> constraintFactory;
    private final String constraintPackage;
    private final String constraintName;
    private Function<Solution_, Score<?>> constraintWeightExtractor;
    private final boolean positive;
    private final List<BavetFromUniConstraintStream<Solution_, Object>> fromStreamList;

    public BavetConstraint(BavetConstraintFactory<Solution_> constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, boolean positive, List<BavetFromUniConstraintStream<Solution_, Object>> fromStreamList) {
        this.constraintFactory = constraintFactory;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.positive = positive;
        this.fromStreamList = fromStreamList;
    }

    public Score<?> extractConstraintWeight(Solution_ workingSolution) {
        Score<?> constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        this.constraintFactory.getSolutionDescriptor().validateConstraintWeight(this.constraintPackage, this.constraintName, constraintWeight);
        return this.positive ? constraintWeight : constraintWeight.negate();
    }

    public void createNodes(BavetNodeBuildPolicy<Solution_> buildPolicy, Map<Class<?>, BavetFromUniNode<Object>> declaredClassToNodeMap, Score<?> constraintWeight) {
        for (BavetFromUniConstraintStream<Solution_, Object> fromStream : this.fromStreamList) {
            int nodeOrder = 0;
            BavetAbstractUniNode node = fromStream.createNodeChain((BavetNodeBuildPolicy)buildPolicy, (Score)constraintWeight, nodeOrder, (BavetAbstractUniNode)null);
            BavetFromUniNode<Object> oldNode = declaredClassToNodeMap.putIfAbsent(fromStream.getFromClass(), (BavetFromUniNode<Object>)node);
            if (oldNode == null || oldNode == node) continue;
            throw new IllegalStateException("The oldNode (" + oldNode + ") differs from the new node (" + node + ").");
        }
    }

    @Override
    public BavetConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }
}

