/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.tri;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBridgeBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBridgeBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndex;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriTuple;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetJoinTriTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniTuple;

public final class BavetJoinTriNode<A, B, C>
extends BavetAbstractTriNode<A, B, C>
implements BavetJoinNode {
    private final BavetJoinBridgeBiNode<A, B> leftParentNode;
    private final BavetJoinBridgeUniNode<C> rightParentNode;
    private final List<BavetAbstractTriNode<A, B, C>> childNodeList = new ArrayList<BavetAbstractTriNode<A, B, C>>();

    public BavetJoinTriNode(BavetConstraintSession session, int nodeOrder, BavetJoinBridgeBiNode<A, B> leftParentNode, BavetJoinBridgeUniNode<C> rightParentNode) {
        super(session, nodeOrder);
        this.leftParentNode = leftParentNode;
        this.rightParentNode = rightParentNode;
    }

    @Override
    public void addChildNode(BavetAbstractTriNode<A, B, C> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public BavetJoinTriTuple<A, B, C> createTuple(BavetAbstractTriTuple<A, B, C> parentTuple) {
        throw new IllegalStateException("The join node (" + this.getClass().getSimpleName() + ") can't have a parentTuple (" + parentTuple + ");");
    }

    public BavetJoinTriTuple<A, B, C> createTuple(BavetJoinBridgeBiTuple<A, B> abTuple, BavetJoinBridgeUniTuple<C> cTuple) {
        return new BavetJoinTriTuple<A, B, C>(this, abTuple, cTuple);
    }

    public void refresh(BavetJoinTriTuple<A, B, C> tuple) {
        List<BavetAbstractTriTuple<A, B, C>> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTriTuple<A, B, C> bavetAbstractTriTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTriTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive()) {
            for (BavetAbstractTriNode bavetAbstractTriNode : this.childNodeList) {
                BavetAbstractTriTuple<A, B, C> childTuple = bavetAbstractTriNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
        tuple.refreshed();
    }

    public void refreshChildTuplesLeft(BavetJoinBridgeBiTuple<A, B> leftParentTuple) {
        Set<BavetJoinTuple> leftTupleSet = leftParentTuple.getChildTupleSet();
        for (BavetJoinTuple tuple_ : leftTupleSet) {
            BavetJoinTriTuple tuple = (BavetJoinTriTuple)tuple_;
            boolean removed = tuple.getCTuple().getChildTupleSet().remove(tuple);
            if (!removed) {
                throw new IllegalStateException("Impossible state: the facts (" + tuple.getFactA() + ", " + tuple.getFactB() + ")'s tuple cannot be removed from the other fact (" + tuple.getFactC() + ")'s join bridge.");
            }
            this.session.transitionTuple(tuple, BavetTupleState.DYING);
        }
        leftTupleSet.clear();
        if (leftParentTuple.isActive()) {
            Set<BavetJoinBridgeUniTuple<C>> rightParentTupleList = this.getRightIndex().get(leftParentTuple.getIndexProperties());
            for (BavetJoinBridgeUniTuple<C> rightParentTuple : rightParentTupleList) {
                if (rightParentTuple.isDirty()) continue;
                BavetJoinTriTuple<A, B, C> childTuple = this.createTuple(leftParentTuple, rightParentTuple);
                leftTupleSet.add(childTuple);
                rightParentTuple.getChildTupleSet().add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public void refreshChildTuplesRight(BavetJoinBridgeUniTuple<C> rightParentTuple) {
        Set<BavetJoinTuple> rightTupleSet = rightParentTuple.getChildTupleSet();
        for (BavetJoinTuple uncastTuple : rightTupleSet) {
            BavetJoinTriTuple tuple = (BavetJoinTriTuple)uncastTuple;
            boolean removed = tuple.getAbTuple().getChildTupleSet().remove(tuple);
            if (!removed) {
                throw new IllegalStateException("Impossible state: the fact (" + tuple.getFactC() + ")'s tuple cannot be removed from the other facts (" + tuple.getFactA() + ", " + tuple.getFactB() + ")'s join bridge.");
            }
            this.session.transitionTuple(tuple, BavetTupleState.DYING);
        }
        rightTupleSet.clear();
        if (rightParentTuple.isActive()) {
            Set<BavetJoinBridgeBiTuple<A, B>> leftParentTupleList = this.getLeftIndex().get(rightParentTuple.getIndexProperties());
            for (BavetJoinBridgeBiTuple<A, B> leftParentTuple : leftParentTupleList) {
                if (leftParentTuple.isDirty()) continue;
                BavetJoinTriTuple<A, B, C> childTuple = this.createTuple(leftParentTuple, rightParentTuple);
                leftParentTuple.getChildTupleSet().add(childTuple);
                rightTupleSet.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public BavetIndex<BavetJoinBridgeBiTuple<A, B>> getLeftIndex() {
        return this.leftParentNode.getIndex();
    }

    public BavetIndex<BavetJoinBridgeUniTuple<C>> getRightIndex() {
        return this.rightParentNode.getIndex();
    }

    public String toString() {
        return "Join() with " + this.childNodeList.size() + " children";
    }
}

