/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;

public final class DroolsGroupByAccumulator<A, B, ResultContainer, NewB>
implements Serializable {
    private final Map<ResultContainer, Long> containersInUse = new IdentityHashMap<ResultContainer, Long>(0);
    private final Map<A, ResultContainer> containers = new LinkedHashMap<A, ResultContainer>(0);
    private final Supplier<ResultContainer> supplier;
    private final BiFunction<ResultContainer, B, Runnable> accumulator;
    private final Function<ResultContainer, NewB> finisher;
    private final transient Set<Pair<A, NewB>> result = new LinkedHashSet<Pair<A, NewB>>(0);

    public DroolsGroupByAccumulator(UniConstraintCollector<B, ResultContainer, NewB> collector) {
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    private static Long increment(Long count) {
        return count == null ? 1L : count + 1L;
    }

    private static Long decrement(Long count) {
        return count == 1L ? null : Long.valueOf(count - 1L);
    }

    public Runnable accumulate(A key, B value) {
        Object container = this.containers.computeIfAbsent(key, __ -> this.supplier.get());
        Runnable undo = this.accumulator.apply(container, value);
        this.containersInUse.compute(container, (__, count) -> DroolsGroupByAccumulator.increment(count));
        return () -> {
            undo.run();
            Long currentCount = this.containersInUse.compute(container, (__, count) -> DroolsGroupByAccumulator.decrement(count));
            if (currentCount == null) {
                this.containers.remove(key);
            }
        };
    }

    public Set<Pair<A, NewB>> finish() {
        this.result.clear();
        for (Map.Entry<A, ResultContainer> entry : this.containers.entrySet()) {
            ResultContainer container = entry.getValue();
            this.result.add(new Pair<A, NewB>(entry.getKey(), this.finisher.apply(container)));
        }
        return this.result;
    }

    public static final class Pair<K, V> {
        public final K key;
        public final V value;
        private final int hashCode;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
            this.hashCode = Objects.hash(key, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !Objects.equals(this.getClass(), o.getClass())) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Pair[" + this.key + ", " + this.value + "]";
        }
    }
}

