/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import org.drools.model.AlphaIndex;
import org.drools.model.BetaIndex;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsCondition;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniAccumulateFunctionBridge;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniToBiGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniToQuadGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniToTriGroupByInvoker;

public final class DroolsUniCondition<A>
extends DroolsCondition<DroolsUniRuleStructure<A>> {
    public DroolsUniCondition(Class<A> aVariableType, LongSupplier variableIdSupplier) {
        this(new DroolsUniRuleStructure<A>(aVariableType, variableIdSupplier));
    }

    public DroolsUniCondition(DroolsUniRuleStructure<A> ruleStructure) {
        super(ruleStructure);
    }

    public static Index.ConstraintType getConstraintType(JoinerType type) {
        switch (type) {
            case EQUAL: {
                return Index.ConstraintType.EQUAL;
            }
            case LESS_THAN: {
                return Index.ConstraintType.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return Index.ConstraintType.LESS_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Index.ConstraintType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Index.ConstraintType.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Unsupported joiner type (" + (Object)((Object)type) + ").");
    }

    public DroolsUniCondition<A> andFilter(Predicate<A> predicate) {
        Predicate1 & Serializable filter = (Predicate1 & Serializable)a -> predicate.test(a);
        AlphaIndex index = PatternDSL.alphaIndexedBy(Boolean.class, (Index.ConstraintType)Index.ConstraintType.EQUAL, (int)-1, (Function1 & Serializable)a -> predicate.test(a), (Object)true);
        UnaryOperator patternWithFilter = p -> p.expr("Filter using " + predicate, filter, index);
        DroolsUniRuleStructure newStructure = ((DroolsUniRuleStructure)this.ruleStructure).amend(patternWithFilter);
        return new DroolsUniCondition(newStructure);
    }

    public <NewA, __> DroolsUniCondition<NewA> andCollect(UniConstraintCollector<A, __, NewA> collector) {
        DroolsUniAccumulateFunctionBridge<A, __, NewA> bridge = new DroolsUniAccumulateFunctionBridge<A, __, NewA>(collector);
        return this.collect(bridge, (pattern, tuple) -> pattern.bind(tuple, (Function1 & Serializable)a -> a));
    }

    public <NewA> DroolsUniCondition<NewA> andGroup(Function<A, NewA> groupKeyMapping) {
        return this.group((pattern, tuple) -> pattern.bind(tuple, (Function1 & Serializable)a -> groupKeyMapping.apply(a)));
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB> andGroupWithCollect(Function<A, NewA> groupKeyMapping, UniConstraintCollector<A, ?, NewB> collector) {
        return this.groupWithCollect(() -> new DroolsUniToBiGroupByInvoker(groupKeyMapping, collector, ((DroolsUniRuleStructure)this.getRuleStructure()).getA()));
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB> andGroupBi(Function<A, NewA> groupKeyAMapping, Function<A, NewB> groupKeyBMapping) {
        return this.groupBi((pattern, tuple) -> pattern.bind(tuple, (Function1 & Serializable)a -> {
            Object newA = groupKeyAMapping.apply(a);
            Object newB = groupKeyBMapping.apply(a);
            return new BiTuple(newA, newB);
        }));
    }

    public <NewA, NewB, NewC> DroolsTriCondition<NewA, NewB, NewC> andGroupBiWithCollect(Function<A, NewA> groupKeyAMapping, Function<A, NewB> groupKeyBMapping, UniConstraintCollector<A, ?, NewC> collector) {
        return this.groupBiWithCollect(() -> new DroolsUniToTriGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collector, ((DroolsUniRuleStructure)this.getRuleStructure()).getA()));
    }

    public <NewA, NewB, NewC, NewD> DroolsQuadCondition<NewA, NewB, NewC, NewD> andGroupBiWithCollectBi(Function<A, NewA> groupKeyAMapping, Function<A, NewB> groupKeyBMapping, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        return this.groupBiWithCollectBi(() -> new DroolsUniToQuadGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collectorC, collectorD, ((DroolsUniRuleStructure)this.getRuleStructure()).getA()));
    }

    public <B> DroolsBiCondition<A, B> andJoin(DroolsUniCondition<B> bCondition, AbstractBiJoiner<A, B> biJoiner) {
        JoinerType[] joinerTypes = biJoiner.getJoinerTypes();
        Function<Object, Object> aJoiner = UnaryOperator.identity();
        Variable[] joinVars = new Variable[joinerTypes.length];
        int mappingIndex = 0;
        while (mappingIndex < joinerTypes.length) {
            int currentMappingIndex = mappingIndex++;
            Variable joinVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable("joinVar" + currentMappingIndex);
            Function leftMapping = biJoiner.getLeftMapping(currentMappingIndex);
            aJoiner = aJoiner.andThen(p -> p.bind(joinVar, (Function1 & Serializable)a -> leftMapping.apply(a)));
            joinVars[currentMappingIndex] = joinVar;
        }
        DroolsUniRuleStructure newARuleStructure = ((DroolsUniRuleStructure)this.ruleStructure).amend(aJoiner::apply);
        Function<Object, Object> bJoiner = UnaryOperator.identity();
        int mappingIndex2 = 0;
        while (mappingIndex2 < joinerTypes.length) {
            int currentMappingIndex = mappingIndex2++;
            JoinerType joinerType = joinerTypes[currentMappingIndex];
            Function leftMapping = biJoiner.getLeftMapping(currentMappingIndex);
            Function rightMapping = biJoiner.getRightMapping(currentMappingIndex);
            Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(b);
            Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(a, rightExtractor.apply(b));
            bJoiner = bJoiner.andThen(p -> {
                BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)DroolsUniCondition.getConstraintType(joinerType), (int)currentMappingIndex, (Function1)rightExtractor, leftMapping::apply);
                return p.expr("Join using joiner #" + currentMappingIndex + " in " + biJoiner, joinVars[currentMappingIndex], predicate, index);
            });
        }
        DroolsUniRuleStructure newBRuleStructure = ((DroolsUniRuleStructure)bCondition.ruleStructure).amend(bJoiner::apply);
        return new DroolsBiCondition(new DroolsBiRuleStructure(newARuleStructure, newBRuleStructure, ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier()));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, __) -> this.impactScore((Drools)drools, scoreHolder));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntFunction<A> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsInt(a)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongFunction<A> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsLong(a)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Function<A, BigDecimal> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> this.impactScore((Drools)drools, scoreHolder, (BigDecimal)matchWeighter.apply(a)));
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block3<Drools, ScoreHolder, A> consequenceImpl) {
        ConsequenceBuilder._2 consequence = DSL.on(scoreHolderGlobal, ((DroolsUniRuleStructure)this.ruleStructure).getA()).execute(consequenceImpl);
        return ((DroolsUniRuleStructure)this.ruleStructure).finish((ConsequenceBuilder.AbstractValidBuilder<?>)consequence);
    }
}

