/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreHolder;
import org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreInliner;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardSoftBigDecimalScoreDefinition
extends AbstractScoreDefinition<HardSoftBigDecimalScore> {
    public HardSoftBigDecimalScoreDefinition() {
        super(new String[]{"hard score", "soft score"});
    }

    @Override
    public int getLevelsSize() {
        return 2;
    }

    @Override
    public int getFeasibleLevelsSize() {
        return 1;
    }

    @Override
    public Class<HardSoftBigDecimalScore> getScoreClass() {
        return HardSoftBigDecimalScore.class;
    }

    @Override
    public HardSoftBigDecimalScore getZeroScore() {
        return HardSoftBigDecimalScore.ZERO;
    }

    @Override
    public HardSoftBigDecimalScore getOneSoftestScore() {
        return HardSoftBigDecimalScore.ONE_SOFT;
    }

    @Override
    public HardSoftBigDecimalScore parseScore(String scoreString) {
        return HardSoftBigDecimalScore.parseScore(scoreString);
    }

    @Override
    public HardSoftBigDecimalScore fromLevelNumbers(int initScore, Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        return HardSoftBigDecimalScore.ofUninitialized(initScore, (BigDecimal)levelNumbers[0], (BigDecimal)levelNumbers[1]);
    }

    public HardSoftBigDecimalScoreInliner buildScoreInliner(boolean constraintMatchEnabled) {
        return new HardSoftBigDecimalScoreInliner(constraintMatchEnabled);
    }

    public HardSoftBigDecimalScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new HardSoftBigDecimalScoreHolder(constraintMatchEnabled);
    }

    @Override
    public HardSoftBigDecimalScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, HardSoftBigDecimalScore score) {
        throw new UnsupportedOperationException("PLANNER-232: BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }

    @Override
    public HardSoftBigDecimalScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, HardSoftBigDecimalScore score) {
        throw new UnsupportedOperationException("PLANNER-232: BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }

    @Override
    public HardSoftBigDecimalScore divideBySanitizedDivisor(HardSoftBigDecimalScore dividend, HardSoftBigDecimalScore divisor) {
        int dividendInitScore = dividend.getInitScore();
        int divisorInitScore = HardSoftBigDecimalScoreDefinition.sanitize(divisor.getInitScore());
        BigDecimal dividendHardScore = dividend.getHardScore();
        BigDecimal divisorHardScore = HardSoftBigDecimalScoreDefinition.sanitize(divisor.getHardScore());
        BigDecimal dividendSoftScore = dividend.getSoftScore();
        BigDecimal divisorSoftScore = HardSoftBigDecimalScoreDefinition.sanitize(divisor.getSoftScore());
        return this.fromLevelNumbers(HardSoftBigDecimalScoreDefinition.divide(dividendInitScore, divisorInitScore), new Number[]{HardSoftBigDecimalScoreDefinition.divide(dividendHardScore, divisorHardScore), HardSoftBigDecimalScoreDefinition.divide(dividendSoftScore, divisorSoftScore)});
    }
}

