/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.impl.score.stream.drools.common.GroupByCollectorProcessor;

abstract class DroolsAbstractGroupByCollectorProcessor<InTuple, KeyTuple, OutTuple>
implements GroupByCollectorProcessor<InTuple, OutTuple> {
    private final Map<KeyTuple, Long> tuplesInUseMap = new HashMap<KeyTuple, Long>(0);
    private Set<KeyTuple> dirtyTupleSet;

    DroolsAbstractGroupByCollectorProcessor() {
    }

    private static Long increment(Long count) {
        return count == null ? 1L : count + 1L;
    }

    private static Long decrement(Long count) {
        return count == 1L ? null : Long.valueOf(count - 1L);
    }

    protected void addTuple(KeyTuple tuple) {
        this.tuplesInUseMap.compute(tuple, (__, count) -> DroolsAbstractGroupByCollectorProcessor.increment(count));
        this.markDirty(tuple);
    }

    protected long removeTuple(KeyTuple tuple) {
        Long useCount = this.tuplesInUseMap.compute(tuple, (__, count) -> DroolsAbstractGroupByCollectorProcessor.decrement(count));
        if (useCount == null) {
            this.unmarkDirty(tuple);
            return 0L;
        }
        this.markDirty(tuple);
        return useCount;
    }

    private void markDirty(KeyTuple tuple) {
        if (this.dirtyTupleSet == null) {
            this.dirtyTupleSet = new LinkedHashSet<KeyTuple>(1);
        }
        this.dirtyTupleSet.add(tuple);
    }

    private void unmarkDirty(KeyTuple tuple) {
        if (this.dirtyTupleSet != null) {
            this.dirtyTupleSet.remove(tuple);
            if (this.dirtyTupleSet.isEmpty()) {
                this.clearDirtyTupleSet();
            }
        }
    }

    protected Set<KeyTuple> clearDirtyTupleSet() {
        if (this.dirtyTupleSet == null) {
            return Collections.emptySet();
        }
        Set<KeyTuple> currentDirtyTupleSet = this.dirtyTupleSet;
        this.dirtyTupleSet = null;
        return currentDirtyTupleSet;
    }
}

