/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBridgeBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndex;

public final class BavetJoinBridgeBiNode<A, B>
extends BavetAbstractBiNode<A, B>
implements BavetJoinBridgeNode {
    private final BavetAbstractBiNode<A, B> parentNode;
    private final BiFunction<A, B, Object[]> mapping;
    private Consumer<BavetJoinBridgeBiTuple<A, B>> childTupleRefresher;
    private final BavetIndex<BavetJoinBridgeBiTuple<A, B>> index;

    public BavetJoinBridgeBiNode(BavetConstraintSession session, int nodeOrder, BavetAbstractBiNode<A, B> parentNode, BiFunction<A, B, Object[]> mapping, BavetIndex<BavetJoinBridgeBiTuple<A, B>> index) {
        super(session, nodeOrder);
        this.parentNode = parentNode;
        this.mapping = mapping;
        this.index = index;
    }

    @Override
    public BavetJoinBridgeBiTuple<A, B> createTuple(BavetAbstractBiTuple<A, B> parentTuple) {
        return new BavetJoinBridgeBiTuple<A, B>(this, parentTuple);
    }

    public void refresh(BavetJoinBridgeBiTuple<A, B> tuple) {
        A a = tuple.getFactA();
        B b = tuple.getFactB();
        if (tuple.getState() != BavetTupleState.CREATING) {
            this.index.remove(tuple);
        }
        if (tuple.isActive()) {
            Object[] indexProperties = this.mapping.apply(a, b);
            this.index.put(indexProperties, tuple);
        }
        this.childTupleRefresher.accept(tuple);
        tuple.refreshed();
    }

    public String toString() {
        return "JoinBridge()";
    }

    public BavetIndex<BavetJoinBridgeBiTuple<A, B>> getIndex() {
        return this.index;
    }

    public void setChildTupleRefresher(Consumer<BavetJoinBridgeBiTuple<A, B>> childTupleRefresher) {
        this.childTupleRefresher = childTupleRefresher;
    }
}

